/*
 * Decompiled with CFR 0.152.
 */
package org.incal.dl4j;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.incal.core.util.ReflectionUtil$;
import org.incal.dl4j.DL4JHelper;
import org.incal.dl4j.DL4JHelper$;
import org.incal.dl4j.TimeSeriesClassificationSpec;
import org.incal.dl4j.TimeSeriesClassificationWithRandomSplitSpec;
import org.incal.dl4j.TimeSeriesDataSetIterator$;
import org.nd4j.evaluation.BaseEvaluation;
import org.nd4j.evaluation.EvaluationAveraging;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.evaluation.classification.Evaluation;
import org.nd4j.evaluation.classification.ROC;
import org.nd4j.evaluation.curves.PrecisionRecallCurve;
import org.nd4j.evaluation.curves.RocCurve;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class DL4JHelper$class {
    public static void run(DL4JHelper $this, TimeSeriesClassificationSpec input) {
        String featuresDir = new StringBuilder().append((Object)"file:////").append((Object)input.featuresBaseDir()).toString();
        String expectedOutputDir = new StringBuilder().append((Object)"file:////").append((Object)input.expectedOutputBaseDir()).toString();
        DataSetIterator trainingData = TimeSeriesDataSetIterator$.MODULE$.apply(input.batchSize(), input.outputNum(), featuresDir, expectedOutputDir, input.trainingStartIndex(), input.trainingEndIndex(), 1);
        DataSetIterator validationData = TimeSeriesDataSetIterator$.MODULE$.apply(input.batchSize(), input.outputNum(), featuresDir, expectedOutputDir, input.validationStartIndex(), input.validationEndIndex(), 1);
        $this.log().info("Building a CNN model....");
        ComputationGraphConfiguration config = $this.createCNN1D(input.numRows(), input.numColumns(), input.outputNum(), input.learningRate(), input.kernelSize(), input.poolingKernelSize(), input.convolutionFeaturesNums(), input.dropOut(), input.lossClassWeights());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DL4JHelper.class.getClassLoader());
        public final class Org_incal_dl4j_DL4JHelper$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.incal.dl4j.TimeSeriesClassificationSpec").asType().toTypeConstructor();
            }

            public Org_incal_dl4j_DL4JHelper$$typecreator2$1(DL4JHelper $outer) {
            }
        }
        $this.launchAndReportResults(config, trainingData, validationData, input.numEpochs(), input.outputNum(), input.resultsExportDir(), new Some((Object)input), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_incal_dl4j_DL4JHelper$$typecreator2$1($this)), ClassTag$.MODULE$.apply(TimeSeriesClassificationSpec.class));
    }

    public static void run(DL4JHelper $this, TimeSeriesClassificationWithRandomSplitSpec input) {
        String featuresDir = new StringBuilder().append((Object)"file:////").append((Object)input.featuresBaseDir()).toString();
        String expectedOutputDir = new StringBuilder().append((Object)"file:////").append((Object)input.expectedOutputBaseDir()).toString();
        Tuple2<DataSetIterator, DataSetIterator> tuple2 = TimeSeriesDataSetIterator$.MODULE$.apply(input.batchSize(), input.outputNum(), featuresDir, expectedOutputDir, input.startIndex(), input.endIndex(), input.trainingValidationSplitRatio(), 1);
        if (tuple2 != null) {
            Tuple2 tuple22;
            DataSetIterator trainingData = (DataSetIterator)tuple2._1();
            DataSetIterator validationData = (DataSetIterator)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)trainingData, (Object)validationData);
            DataSetIterator trainingData2 = (DataSetIterator)tuple23._1();
            DataSetIterator validationData2 = (DataSetIterator)tuple23._2();
            $this.log().info("Building a CNN model....");
            ComputationGraphConfiguration config = $this.createCNN1D(input.numRows(), input.numColumns(), input.outputNum(), input.learningRate(), input.kernelSize(), input.poolingKernelSize(), input.convolutionFeaturesNums(), input.dropOut(), input.lossClassWeights());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DL4JHelper.class.getClassLoader());
            public final class Org_incal_dl4j_DL4JHelper$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.incal.dl4j.TimeSeriesClassificationWithRandomSplitSpec").asType().toTypeConstructor();
                }

                public Org_incal_dl4j_DL4JHelper$$typecreator1$1(DL4JHelper $outer) {
                }
            }
            $this.launchAndReportResults(config, trainingData2, validationData2, input.numEpochs(), input.outputNum(), input.resultsExportDir(), new Some((Object)input), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_incal_dl4j_DL4JHelper$$typecreator1$1($this)), ClassTag$.MODULE$.apply(TimeSeriesClassificationWithRandomSplitSpec.class));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static ComputationGraphConfiguration createCNN1D(DL4JHelper $this, int numRows, int numColumns, int outputNum, double learningRate, int kernelSize, int poolingKernelSize, Seq convolutionFeaturesNums, double dropOut, Seq lossClassWeights) {
        ComputationGraphConfiguration.GraphBuilder conf = new NeuralNetConfiguration.Builder().weightInit(WeightInit.XAVIER).updater((IUpdater)new Adam(learningRate)).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).convolutionMode(ConvolutionMode.Truncate).graphBuilder().addInputs(new String[]{"0"});
        int cnnLayersNum = convolutionFeaturesNums.size();
        ((IterableLike)convolutionFeaturesNums.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this, conf, cnnLayersNum, numColumns, kernelSize, poolingKernelSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DL4JHelper $outer;
            private final ComputationGraphConfiguration.GraphBuilder conf$1;
            private final int cnnLayersNum$1;
            private final int numColumns$1;
            private final int kernelSize$1;
            private final int poolingKernelSize$1;

            public final Object apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    int featuresNum = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    int initChannels = index == 0 ? this.numColumns$1 : 1;
                    this.conf$1.layer(3 * index + 1, (Layer)DL4JHelper$class.convolution$1(this.$outer, featuresNum, initChannels, this.kernelSize$1), new String[]{((Object)BoxesRunTime.boxToInteger((int)(3 * index))).toString()}).layer(3 * index + 2, (Layer)DL4JHelper$class.convolution$1(this.$outer, featuresNum, 1, this.kernelSize$1), new String[]{((Object)BoxesRunTime.boxToInteger((int)(3 * index + 1))).toString()});
                    BoxedUnit boxedUnit = index < this.cnnLayersNum$1 - 1 ? this.conf$1.layer(3 * index + 3, (Layer)DL4JHelper$class.maxPoolingType$1(this.$outer, this.poolingKernelSize$1), new String[]{((Object)BoxesRunTime.boxToInteger((int)(3 * index + 2))).toString()}) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conf$1 = conf$1;
                this.cnnLayersNum$1 = cnnLayersNum$1;
                this.numColumns$1 = numColumns$1;
                this.kernelSize$1 = kernelSize$1;
                this.poolingKernelSize$1 = poolingKernelSize$1;
            }
        });
        conf.layer(3 * cnnLayersNum, (Layer)new GlobalPoolingLayer.Builder().poolingType(PoolingType.AVG).build(), new String[]{((Object)BoxesRunTime.boxToInteger((int)(3 * cnnLayersNum - 1))).toString()});
        LossBinaryXENT lossFunction = outputNum == 2 ? (lossClassWeights.nonEmpty() ? new LossBinaryXENT(Nd4j.create((double[])((double[])lossClassWeights.toArray(ClassTag$.MODULE$.Double())))) : new LossBinaryXENT()) : (lossClassWeights.nonEmpty() ? new LossMCXENT(Nd4j.create((double[])((double[])lossClassWeights.toArray(ClassTag$.MODULE$.Double())))) : new LossMCXENT());
        Activation activation = outputNum == 2 ? Activation.SIGMOID : Activation.SOFTMAX;
        return conf.layer("output", (Layer)((OutputLayer.Builder)((FeedForwardLayer.Builder)new OutputLayer.Builder((ILossFunction)lossFunction).dropOut(dropOut)).nOut(outputNum).activation(activation)).build(), new String[]{((Object)BoxesRunTime.boxToInteger((int)(3 * cnnLayersNum))).toString()}).setOutputs(new String[]{"output"}).setInputTypes(new InputType[]{InputType.convolutional((long)numRows, (long)numColumns, (long)1L)}).build();
    }

    public static Seq createCNN1D$default$9(DL4JHelper $this) {
        return Nil$.MODULE$;
    }

    public static void launchAndReportResults(DL4JHelper $this, ComputationGraphConfiguration config, DataSetIterator trainData, DataSetIterator validationData, int numEpochs, int outputNum, String exportDir, Option inputsToReport, TypeTags.TypeTag evidence$1, ClassTag evidence$2) {
        Date startTime = new Date();
        String startTimeString = $this.org$incal$dl4j$DL4JHelper$$dateTimeFormat().format(startTime);
        ComputationGraph model = new ComputationGraph(config);
        model.init();
        Seq inputParams = (Seq)inputsToReport.map((Function1)new Serializable($this, evidence$1, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DL4JHelper $outer;
            private final TypeTags.TypeTag evidence$1$1;
            private final ClassTag evidence$2$1;

            /*
             * WARNING - void declaration
             */
            public final Seq<String> apply(T input) {
                void var2_2;
                Seq params = (Seq)((TraversableOnce)ReflectionUtil$.MODULE$.getCaseClassMemberNamesAndValues(input, ReflectionUtil$.MODULE$.getCaseClassMemberNamesAndValues$default$2(), this.evidence$1$1, this.evidence$2$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            Object value = tuple2._2();
                            String valueString = value instanceof Traversable ? ((Traversable)value).mkString(", ") : value.toString();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, valueString}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Traversable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
                this.$outer.log().info(new StringBuilder().append((Object)"Input: ").append((Object)params.mkString(", ")).toString());
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.evidence$1$1 = evidence$1$1;
                this.evidence$2$1 = evidence$2$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        $this.log().info("Training the model....");
        IndexedSeq trainValidationEvals = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numEpochs).map((Function1)new Serializable($this, model, trainData, validationData, outputNum){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DL4JHelper $outer;
            private final ComputationGraph model$1;
            private final DataSetIterator trainData$1;
            private final DataSetIterator validationData$1;
            private final int outputNum$1;

            public final Tuple2<Tuple3<Evaluation, Option<RocCurve>, Option<PrecisionRecallCurve>>, Tuple3<Evaluation, Option<RocCurve>, Option<PrecisionRecallCurve>>> apply(int i) {
                this.model$1.fit(this.trainData$1);
                this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*** Completed epoch ", " ***"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                Tuple3 trainingEval = DL4JHelper$class.evaluate$1(this.$outer, this.trainData$1, "Training  ", this.model$1, this.outputNum$1);
                Tuple3 validationEval = DL4JHelper$class.evaluate$1(this.$outer, this.validationData$1, "Validation", this.model$1, this.outputNum$1);
                return new Tuple2((Object)trainingEval, (Object)validationEval);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.model$1 = model$1;
                this.trainData$1 = trainData$1;
                this.validationData$1 = validationData$1;
                this.outputNum$1 = outputNum$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        $this.log().info("*** Training finished ***");
        if (inputParams.nonEmpty()) {
            String paramsFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CNN_DL4J-", "-input"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startTimeString}));
            org.incal.core.util.package$.MODULE$.writeStringAsStream(inputParams.mkString("\n"), new File(new StringBuilder().append((Object)exportDir).append((Object)"/").append((Object)paramsFileName).toString()));
        }
        String evalOutputFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CNN_DL4J-", "-evals.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startTimeString}));
        String evalOutput = ((TraversableOnce)((TraversableLike)trainValidationEvals.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, outputNum){
            public static final long serialVersionUID = 0L;
            private final int outputNum$1;

            public final String apply(Tuple2<Tuple2<Tuple3<Evaluation, Option<RocCurve>, Option<PrecisionRecallCurve>>, Tuple3<Evaluation, Option<RocCurve>, Option<PrecisionRecallCurve>>>, Object> x0$2) {
                Tuple2<Tuple2<Tuple3<Evaluation, Option<RocCurve>, Option<PrecisionRecallCurve>>, Tuple3<Evaluation, Option<RocCurve>, Option<PrecisionRecallCurve>>>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        Tuple3 tuple3 = (Tuple3)tuple22._1();
                        Tuple3 tuple32 = (Tuple3)tuple22._2();
                        if (tuple3 != null) {
                            Evaluation trainingEval = (Evaluation)tuple3._1();
                            Option trainingRocCurve = (Option)tuple3._2();
                            Option trainingPrCurve = (Option)tuple3._3();
                            if (tuple32 != null) {
                                String string;
                                Evaluation validationEval = (Evaluation)tuple32._1();
                                Option validationRocCurve = (Option)tuple32._2();
                                Option validationPrCurve = (Option)tuple32._3();
                                double trainingAccuracy = trainingEval.accuracy();
                                double validationAccuracy = validationEval.accuracy();
                                if (this.outputNum$1 == 2) {
                                    double trainingF1Class0 = trainingEval.f1(0);
                                    double trainingF1Class1 = trainingEval.f1(1);
                                    String trainingAUROC = (String)trainingRocCurve.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(RocCurve x$2) {
                                            return ((Object)BoxesRunTime.boxToDouble((double)x$2.calculateAUC())).toString();
                                        }
                                    }).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    String trainingAUPR = (String)trainingPrCurve.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(PrecisionRecallCurve x$3) {
                                            return ((Object)BoxesRunTime.boxToDouble((double)x$3.calculateAUPRC())).toString();
                                        }
                                    }).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    double validationF1Class0 = validationEval.f1(0);
                                    double validationF1Class1 = validationEval.f1(1);
                                    String validationAUROC = (String)validationRocCurve.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(RocCurve x$4) {
                                            return ((Object)BoxesRunTime.boxToDouble((double)x$4.calculateAUC())).toString();
                                        }
                                    }).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    String validationAUPR = (String)validationPrCurve.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(PrecisionRecallCurve x$5) {
                                            return ((Object)BoxesRunTime.boxToDouble((double)x$5.calculateAUPRC())).toString();
                                        }
                                    }).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    string = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1)), BoxesRunTime.boxToDouble((double)trainingAccuracy), BoxesRunTime.boxToDouble((double)trainingF1Class0), BoxesRunTime.boxToDouble((double)trainingF1Class1), trainingAUROC, trainingAUPR, BoxesRunTime.boxToDouble((double)validationAccuracy), BoxesRunTime.boxToDouble((double)validationF1Class0), BoxesRunTime.boxToDouble((double)validationF1Class1), validationAUROC, validationAUPR}))).mkString(", ");
                                } else {
                                    double trainingMacroF1 = trainingEval.f1(EvaluationAveraging.Macro);
                                    double trainingMicroF1 = trainingEval.f1(EvaluationAveraging.Micro);
                                    double validationMacroF1 = validationEval.f1(EvaluationAveraging.Macro);
                                    double validationMicroF1 = validationEval.f1(EvaluationAveraging.Micro);
                                    string = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{index + 1, trainingAccuracy, trainingMacroF1, trainingMicroF1, validationAccuracy, validationMacroF1, validationMicroF1}))).mkString(", ");
                                }
                                String string2 = string;
                                return string2;
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.outputNum$1 = outputNum$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n");
        String evalHeader = outputNum == 2 ? $this.org$incal$dl4j$DL4JHelper$$binaryOutputEvalHeader() : $this.org$incal$dl4j$DL4JHelper$$outputEvalHeader();
        org.incal.core.util.package$.MODULE$.writeStringAsStream(new StringBuilder().append((Object)evalHeader).append((Object)"\n").append((Object)evalOutput).toString(), new File(new StringBuilder().append((Object)exportDir).append((Object)"/").append((Object)evalOutputFileName).toString()));
        String lastFullEvalOutputFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CNN_DL4J-", "-lasteval"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startTimeString}));
        Tuple2 tuple2 = (Tuple2)trainValidationEvals.last();
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            Tuple3 tuple32 = (Tuple3)tuple2._2();
            if (tuple3 != null) {
                Evaluation lastTrainingEval = (Evaluation)tuple3._1();
                Option lastTrainingRocCurve = (Option)tuple3._2();
                Option lastTrainingPrCurve = (Option)tuple3._3();
                if (tuple32 != null) {
                    Tuple6 tuple6;
                    Evaluation lastValidationEval = (Evaluation)tuple32._1();
                    Option lastValidationRocCurve = (Option)tuple32._2();
                    Option lastValidationPrCurve = (Option)tuple32._3();
                    Tuple6 tuple62 = tuple6 = new Tuple6((Object)lastTrainingEval, (Object)lastTrainingRocCurve, (Object)lastTrainingPrCurve, (Object)lastValidationEval, (Object)lastValidationRocCurve, (Object)lastValidationPrCurve);
                    Evaluation lastTrainingEval2 = (Evaluation)tuple62._1();
                    Option lastTrainingRocCurve2 = (Option)tuple62._2();
                    Option lastTrainingPrCurve2 = (Option)tuple62._3();
                    Evaluation lastValidationEval2 = (Evaluation)tuple62._4();
                    Option lastValidationRocCurve2 = (Option)tuple62._5();
                    Option lastValidationPrCurve2 = (Option)tuple62._6();
                    org.incal.core.util.package$.MODULE$.writeStringAsStream(new StringBuilder().append((Object)"Training:").append((Object)lastTrainingEval2.stats()).append((Object)DL4JHelper$class.rocAsString$1($this, lastTrainingRocCurve2)).append((Object)DL4JHelper$class.prAsString$1($this, lastTrainingPrCurve2)).append((Object)"\n\n").append((Object)"Validation:").append((Object)lastValidationEval2.stats()).append((Object)DL4JHelper$class.rocAsString$1($this, lastValidationRocCurve2)).append((Object)DL4JHelper$class.prAsString$1($this, lastValidationPrCurve2)).toString(), new File(new StringBuilder().append((Object)exportDir).append((Object)"/").append((Object)lastFullEvalOutputFileName).toString()));
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static None$ launchAndReportResults$default$7(DL4JHelper $this) {
        return None$.MODULE$;
    }

    public static final ConvolutionLayer convolution$1(DL4JHelper $this, int out, int channels, int kernelSize$1) {
        return ((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{kernelSize$1, channels}).stride(new int[]{1, 1}).nOut(out).activation(Activation.RELU)).build();
    }

    public static final SubsamplingLayer maxPoolingType$1(DL4JHelper $this, int poolingKernelSize$1) {
        return new SubsamplingLayer.Builder(PoolingType.MAX).kernelSize(new int[]{poolingKernelSize$1, 1}).stride(new int[]{poolingKernelSize$1, 1}).build();
    }

    public static final Tuple3 evaluate$1(DL4JHelper $this, DataSetIterator data, String dataSetName, ComputationGraph model$1, int outputNum$1) {
        Tuple3 tuple3;
        if (outputNum$1 == 2) {
            Evaluation eval = new Evaluation();
            ROC roc = new ROC();
            model$1.doEvaluation(data, (IEvaluation[])new BaseEvaluation[]{eval, roc});
            RocCurve rocCurve = roc.getRocCurve();
            PrecisionRecallCurve prCurve = roc.getPrecisionRecallCurve();
            $this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " accuracy: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSetName, BoxesRunTime.boxToDouble((double)eval.accuracy())})));
            $this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AUROC   : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSetName, BoxesRunTime.boxToDouble((double)rocCurve.calculateAUC())})));
            $this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AUPR    : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSetName, BoxesRunTime.boxToDouble((double)prCurve.calculateAUPRC())})));
            tuple3 = new Tuple3((Object)eval, (Object)new Some((Object)rocCurve), (Object)new Some((Object)prCurve));
        } else {
            Evaluation eval = model$1.evaluate(data);
            $this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " accuracy: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSetName, BoxesRunTime.boxToDouble((double)eval.accuracy())})));
            tuple3 = new Tuple3((Object)eval, (Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        return tuple3;
    }

    private static final String rocAsString$1(DL4JHelper $this, Option curve) {
        return (String)curve.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(RocCurve curve) {
                return new StringBuilder().append((Object)"\n\nFPR: ").append((Object)Predef$.MODULE$.doubleArrayOps(curve.getFpr()).mkString(",")).append((Object)"\n").append((Object)"TPR: ").append((Object)Predef$.MODULE$.doubleArrayOps(curve.getTpr()).mkString(",")).append((Object)"\n\n").toString();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    private static final String prAsString$1(DL4JHelper $this, Option curve) {
        return (String)curve.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(PrecisionRecallCurve curve) {
                return new StringBuilder().append((Object)"Precision: ").append((Object)Predef$.MODULE$.doubleArrayOps(curve.getPrecision()).mkString(",")).append((Object)"\n").append((Object)"Recall: ").append((Object)Predef$.MODULE$.doubleArrayOps(curve.getRecall()).mkString(",")).append((Object)"\n").toString();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    public static void $init$(DL4JHelper $this) {
        $this.org$incal$dl4j$DL4JHelper$_setter_$log_$eq(LoggerFactory.getLogger((String)"DL4J"));
        $this.org$incal$dl4j$DL4JHelper$_setter_$org$incal$dl4j$DL4JHelper$$outputEvalHeader_$eq(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch", "trainingAccuracy", "trainingMacroF1", "trainingMicroF1", "validationAccuracy", "validationMacroF1", "validationMicroF1"}))).mkString(", "));
        $this.org$incal$dl4j$DL4JHelper$_setter_$org$incal$dl4j$DL4JHelper$$binaryOutputEvalHeader_$eq(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch", "trainingAccuracy", "trainingF1Class0", "trainingF1Class1", "trainingAUROC", "trainingAUPR", "validationAccuracy", "validationF1Class0", "validationF1Class1", "validationAUROC", "validationAUPR"}))).mkString(", "));
        $this.org$incal$dl4j$DL4JHelper$_setter_$org$incal$dl4j$DL4JHelper$$dateTimeFormat_$eq(new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss"));
    }
}

