//
// MIT License
//
// Copyright (c) 2024 Incendo
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
package org.incendo.cloud.brigadier.suggestion;

import com.mojang.brigadier.Message;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TooltipSuggestion}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code TooltipSuggestionImpl.of()}.
 */
@Generated(from = "TooltipSuggestion", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@API(status = API.Status.INTERNAL, consumers = "org.incendo.cloud.*")
final class TooltipSuggestionImpl implements TooltipSuggestion {
  private final @NonNull String suggestion;
  private final @Nullable Message tooltip;

  private TooltipSuggestionImpl(
      @NonNull String suggestion,
      @Nullable Message tooltip) {
    this.suggestion = Objects.requireNonNull(suggestion, "suggestion");
    this.tooltip = tooltip;
  }

  private TooltipSuggestionImpl(
      TooltipSuggestionImpl original,
      @NonNull String suggestion,
      @Nullable Message tooltip) {
    this.suggestion = suggestion;
    this.tooltip = tooltip;
  }

  /**
   * @return The value of the {@code suggestion} attribute
   */
  @Override
  public @NonNull String suggestion() {
    return suggestion;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable Message tooltip() {
    return tooltip;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TooltipSuggestion#suggestion() suggestion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for suggestion
   * @return A modified copy or the {@code this} object
   */
  public final TooltipSuggestionImpl withSuggestion(@NonNull String value) {
    @NonNull String newValue = Objects.requireNonNull(value, "suggestion");
    if (this.suggestion.equals(newValue)) return this;
    return new TooltipSuggestionImpl(this, newValue, this.tooltip);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TooltipSuggestion#tooltip() tooltip} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final TooltipSuggestionImpl withTooltip(@Nullable Message value) {
    if (this.tooltip == value) return this;
    return new TooltipSuggestionImpl(this, this.suggestion, value);
  }

  /**
   * This instance is equal to all instances of {@code TooltipSuggestionImpl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TooltipSuggestionImpl
        && equalsByValue((TooltipSuggestionImpl) another);
  }

  private boolean equalsByValue(TooltipSuggestionImpl another) {
    return suggestion.equals(another.suggestion)
        && Objects.equals(tooltip, another.tooltip);
  }

  /**
   * Computes a hash code from attributes: {@code suggestion}, {@code tooltip}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + suggestion.hashCode();
    h += (h << 5) + Objects.hashCode(tooltip);
    return h;
  }

  /**
   * Prints the immutable value {@code TooltipSuggestion} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TooltipSuggestion{"
        + "suggestion=" + suggestion
        + ", tooltip=" + tooltip
        + "}";
  }

  /**
   * Construct a new immutable {@code TooltipSuggestion} instance.
   * @param suggestion The value for the {@code suggestion} attribute
   * @param tooltip The value for the {@code tooltip} attribute
   * @return An immutable TooltipSuggestion instance
   */
  public static TooltipSuggestionImpl of(@NonNull String suggestion, @Nullable Message tooltip) {
    return new TooltipSuggestionImpl(suggestion, tooltip);
  }

  /**
   * Creates an immutable copy of a {@link TooltipSuggestion} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TooltipSuggestion instance
   */
  public static TooltipSuggestionImpl copyOf(TooltipSuggestion instance) {
    if (instance instanceof TooltipSuggestionImpl) {
      return (TooltipSuggestionImpl) instance;
    }
    return TooltipSuggestionImpl.of(instance.suggestion(), instance.tooltip());
  }
}
