/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.brigadier.CloudBrigadierManager;

@API(status=API.Status.INTERNAL)
public final class CloudBrigadierCommand<C, S>
implements Command<S> {
    private final CommandManager<C> commandManager;
    private final CloudBrigadierManager<C, S> brigadierManager;

    public CloudBrigadierCommand(@NonNull CommandManager<C> commandManager, @NonNull CloudBrigadierManager<C, S> brigadierManager) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
    }

    public int run(@NonNull CommandContext<S> ctx) {
        Object source = ctx.getSource();
        String input = ctx.getInput().substring(((ParsedCommandNode)ctx.getLastChild().getNodes().get(0)).getRange().getStart());
        Object sender = this.brigadierManager.senderMapper().map(source);
        this.commandManager.commandExecutor().executeCommand(sender, input, cloudContext -> cloudContext.store("_cloud_brigadier_native_sender", source));
        return 1;
    }
}

