/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.brigadier.permission;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.brigadier.permission.BrigadierPermissionChecker;
import org.incendo.cloud.internal.CommandNode;
import org.incendo.cloud.permission.Permission;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierPermissionPredicate<C, S>
implements Predicate<S> {
    private final SenderMapper<S, C> senderMapper;
    private final BrigadierPermissionChecker<C> permissionChecker;
    private final CommandNode<?> node;

    public BrigadierPermissionPredicate(@NonNull SenderMapper<S, C> senderMapper, @NonNull BrigadierPermissionChecker<C> permissionChecker, @NonNull CommandNode<?> node) {
        this.senderMapper = senderMapper;
        this.permissionChecker = permissionChecker;
        this.node = node;
    }

    @Override
    public boolean test(@NonNull S source) {
        Permission permission = this.node.nodeMeta().getOrDefault("permission", Permission.empty());
        Set senderTypes = this.node.nodeMeta().getOrDefault("senderTypes", Collections.emptySet());
        Object cloudSender = this.senderMapper.map(source);
        if (senderTypes.isEmpty()) {
            return this.permissionChecker.hasPermission(cloudSender, permission);
        }
        for (Class senderType : senderTypes) {
            if (!senderType.isInstance(cloudSender)) continue;
            return this.permissionChecker.hasPermission(cloudSender, permission);
        }
        return false;
    }
}

