/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.fabric;

import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.caption.CaptionFormatter;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricCommandManager;
import org.incendo.cloud.fabric.FabricCommandRegistrationHandler;
import org.incendo.cloud.fabric.internal.LateRegistrationCatcher;
import org.incendo.cloud.minecraft.modded.caption.MinecraftCaptionFormatter;
import org.incendo.cloud.minecraft.modded.internal.ModdedExceptionHandler;
import org.incendo.cloud.minecraft.modded.internal.ModdedParserMappings;

public final class FabricServerCommandManager<C>
extends FabricCommandManager<C, class_2168> {
    private static final boolean HAS_PERMISSIONS_API = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");

    @API(status=API.Status.STABLE, since="2.0.0")
    public static @NonNull FabricServerCommandManager<@NonNull class_2168> createNative(@NonNull ExecutionCoordinator<class_2168> execCoordinator) {
        return new FabricServerCommandManager<class_2168>(execCoordinator, SenderMapper.identity());
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public FabricServerCommandManager(@NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<class_2168, C> senderMapper) {
        super(commandExecutionCoordinator, senderMapper, new FabricCommandRegistrationHandler.Server());
        if (LateRegistrationCatcher.hasServerAlreadyStarted()) {
            throw new IllegalStateException("FabricServerCommandManager was created too late! Because command registration occurs before the server instance is created, commands should be registered in mod initializers.");
        }
        ModdedParserMappings.registerServer((CommandManager)this);
        ModdedExceptionHandler.registerDefaults((CommandManager)this, (CaptionFormatter)new MinecraftCaptionFormatter());
    }

    public boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        class_2168 source = (class_2168)this.senderMapper().reverse(sender);
        if (HAS_PERMISSIONS_API) {
            return Permissions.check((class_2172)source, (String)permission, (int)source.method_9211().method_3798());
        }
        return source.method_9259(source.method_9211().method_3798());
    }
}

