//
// MIT License
//
// Copyright (c) 2024 Incendo
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
package org.incendo.cloud.fabric.internal;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.incendo.cloud.minecraft.modded.internal.AdventureSupport;

@API(status = API.Status.INTERNAL)
@DefaultQualifier(NonNull.class)
public final class CloudFabricEntrypoint implements ModInitializer {

    @SuppressWarnings("EmptyCatch")
    @Override
    public void onInitialize() {
        if (FabricLoader.getInstance().isModLoaded("adventure-platform-fabric")) {
            try {
                Objects.requireNonNull(
                    Class.forName("net.kyori.adventure.platform.modcommon.MinecraftAudiences").getName()
                );

                ServerLifecycleEvents.SERVER_STARTING.register(AdventureSupport.get()::setupServer);
                ServerLifecycleEvents.SERVER_STOPPED.register(AdventureSupport.get()::removeServer);
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    AdventureSupport.get().setupClient();
                }
            } catch (final ClassNotFoundException ignored) {
            }
        }
    }
}
