/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.brigadier.CloudBrigadierCommand;
import org.incendo.cloud.brigadier.util.BrigadierUtil;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.fabric.FabricCommandManager;
import org.incendo.cloud.internal.CommandRegistrationHandler;
import org.incendo.cloud.minecraft.modded.ModdedCommandMetaKeys;
import org.incendo.cloud.minecraft.modded.internal.ContextualArgumentTypeProvider;

abstract class FabricCommandRegistrationHandler<C, S extends class_2172>
implements CommandRegistrationHandler<C> {
    private @MonotonicNonNull FabricCommandManager<C, S> commandManager;

    FabricCommandRegistrationHandler() {
    }

    void initialize(FabricCommandManager<C, S> manager) {
        this.commandManager = manager;
    }

    FabricCommandManager<C, S> commandManager() {
        return this.commandManager;
    }

    static class Server<C>
    extends FabricCommandRegistrationHandler<C, class_2168> {
        private final Set<Command<C>> registeredCommands = ConcurrentHashMap.newKeySet();

        Server() {
        }

        @Override
        void initialize(FabricCommandManager<C, class_2168> manager) {
            super.initialize(manager);
            CommandRegistrationCallback.EVENT.register(this::registerAllCommands);
        }

        public boolean registerCommand(@NonNull Command<C> command) {
            return this.registeredCommands.add(command);
        }

        private void registerAllCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 side) {
            this.commandManager().registrationCalled();
            ContextualArgumentTypeProvider.withBuildContext(this.commandManager(), (class_7157)access, (boolean)true, () -> {
                for (Command<C> command : this.registeredCommands) {
                    class_2170.class_5364 env = (class_2170.class_5364)command.commandMeta().getOrDefault(ModdedCommandMetaKeys.REGISTRATION_ENVIRONMENT, (Object)class_2170.class_5364.field_25419);
                    if (env == class_2170.class_5364.field_25421 && !side.field_25422 || env == class_2170.class_5364.field_25420 && !side.field_25423) continue;
                    this.registerCommand((RootCommandNode<class_2168>)dispatcher.getRoot(), command);
                }
            });
        }

        private void registerCommand(RootCommandNode<class_2168> dispatcher, Command<C> command) {
            CommandComponent component = command.rootComponent();
            LiteralCommandNode baseNode = this.commandManager().brigadierManager().literalBrigadierNodeFactory().createNode(component.name(), command, (com.mojang.brigadier.Command)new CloudBrigadierCommand(this.commandManager(), this.commandManager().brigadierManager()));
            dispatcher.addChild((CommandNode)baseNode);
            for (String alias : component.alternativeAliases()) {
                dispatcher.addChild((CommandNode)BrigadierUtil.buildRedirect((String)alias, (CommandNode)baseNode));
            }
        }
    }

    static class Client<C>
    extends FabricCommandRegistrationHandler<C, FabricClientCommandSource> {
        private final Set<Command<C>> registeredCommands = ConcurrentHashMap.newKeySet();
        private volatile boolean registerEventFired = false;

        Client() {
        }

        @Override
        void initialize(FabricCommandManager<C, FabricClientCommandSource> manager) {
            super.initialize(manager);
            ClientCommandRegistrationCallback.EVENT.register(this::registerCommands);
            ClientPlayConnectionEvents.DISCONNECT.register(($, $$) -> {
                this.registerEventFired = false;
            });
        }

        public boolean registerCommand(@NonNull Command<C> command) {
            this.registeredCommands.add(command);
            if (this.registerEventFired) {
                class_634 connection = class_310.method_1551().method_1562();
                if (connection == null) {
                    throw new IllegalStateException("Expected connection to be present but it wasn't!");
                }
                CommandDispatcher dispatcher = ClientCommandManager.getActiveDispatcher();
                if (dispatcher == null) {
                    throw new IllegalStateException("Expected an active dispatcher!");
                }
                ContextualArgumentTypeProvider.withBuildContext(this.commandManager(), (class_7157)class_7157.method_46722((class_7225.class_7874)connection.method_29091(), (class_7699)connection.method_45735()), (boolean)false, () -> this.registerClientCommand((CommandDispatcher<FabricClientCommandSource>)dispatcher, command));
            }
            return true;
        }

        public void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandBuildContext) {
            this.registerEventFired = true;
            ContextualArgumentTypeProvider.withBuildContext(this.commandManager(), (class_7157)commandBuildContext, (boolean)true, () -> {
                for (Command<C> command : this.registeredCommands) {
                    this.registerClientCommand(dispatcher, command);
                }
            });
        }

        private void registerClientCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, Command<C> command) {
            RootCommandNode rootNode = dispatcher.getRoot();
            CommandComponent component = command.rootComponent();
            LiteralCommandNode baseNode = this.commandManager().brigadierManager().literalBrigadierNodeFactory().createNode(component.name(), command, (com.mojang.brigadier.Command)new CloudBrigadierCommand(this.commandManager(), this.commandManager().brigadierManager()));
            rootNode.addChild((CommandNode)baseNode);
            for (String alias : component.alternativeAliases()) {
                rootNode.addChild((CommandNode)BrigadierUtil.buildRedirect((String)alias, (CommandNode)baseNode));
            }
        }
    }
}

