/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.fabric;

import java.util.function.Supplier;
import net.minecraft.class_2172;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.SenderMapperHolder;
import org.incendo.cloud.brigadier.BrigadierManagerHolder;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.incendo.cloud.caption.CaptionProvider;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.execution.preprocessor.CommandPreprocessor;
import org.incendo.cloud.fabric.FabricCommandRegistrationHandler;
import org.incendo.cloud.minecraft.modded.caption.ModdedDefaultCaptionsProvider;
import org.incendo.cloud.minecraft.modded.internal.ModdedParserMappings;
import org.incendo.cloud.minecraft.modded.internal.ModdedPreprocessor;
import org.incendo.cloud.suggestion.SuggestionFactory;

public abstract class FabricCommandManager<C, S extends class_2172>
extends CommandManager<C>
implements BrigadierManagerHolder<C, S>,
SenderMapperHolder<S, C> {
    private final SenderMapper<S, C> senderMapper;
    private final CloudBrigadierManager<C, S> brigadierManager;
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    @API(status=API.Status.STABLE, since="2.0.0")
    FabricCommandManager(@NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<S, C> senderMapper, @NonNull FabricCommandRegistrationHandler<C, S> registrationHandler, @NonNull Supplier<S> dummyCommandSourceProvider) {
        super(commandExecutionCoordinator, registrationHandler);
        this.senderMapper = senderMapper;
        this.suggestionFactory = super.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
        this.brigadierManager = new CloudBrigadierManager((CommandManager)this, () -> new CommandContext(this.senderMapper.map((Object)((class_2172)dummyCommandSourceProvider.get())), (CommandManager)this), this.senderMapper);
        ModdedParserMappings.register((CommandManager)this, this.brigadierManager);
        this.captionRegistry().registerProvider((CaptionProvider)new ModdedDefaultCaptionsProvider());
        this.registerCommandPreProcessor((CommandPreprocessor)new ModdedPreprocessor(senderMapper));
        ((FabricCommandRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
    }

    public final @NonNull SenderMapper<S, C> senderMapper() {
        return this.senderMapper;
    }

    public final @NonNull SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory() {
        return this.suggestionFactory;
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public final boolean hasBrigadierManager() {
        return true;
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public final @NonNull CloudBrigadierManager<C, S> brigadierManager() {
        return this.brigadierManager;
    }

    final void registrationCalled() {
        this.lockRegistration();
    }
}

