/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.neoforge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.Command;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.internal.CommandNode;
import org.incendo.cloud.minecraft.modded.internal.AdventureSupport;
import org.incendo.cloud.neoforge.NeoForgeClientCommandManager;
import org.incendo.cloud.neoforge.NeoForgeCommandManager;
import org.incendo.cloud.neoforge.NeoForgeServerCommandManager;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.permission.AndPermission;
import org.incendo.cloud.permission.OrPermission;
import org.incendo.cloud.permission.Permission;
import org.incendo.cloud.permission.PredicatePermission;

@API(status=API.Status.INTERNAL)
@Mod(value="cloud")
public final class CloudNeoForgeEntrypoint {
    private static boolean serverStartingCalled;

    public CloudNeoForgeEntrypoint(IEventBus modBus) {
        if (ModList.get().isLoaded("adventure_platform_neoforge")) {
            NeoForge.EVENT_BUS.addListener(event -> AdventureSupport.get().setupServer(event.getServer()));
            NeoForge.EVENT_BUS.addListener(event -> AdventureSupport.get().removeServer(event.getServer()));
            modBus.addListener(FMLClientSetupEvent.class, event -> AdventureSupport.get().setupClient());
        }
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, event -> {
            serverStartingCalled = true;
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, CloudNeoForgeEntrypoint::registerPermissions);
        if (Boolean.getBoolean("cloud.test_commands")) {
            CloudNeoForgeEntrypoint.testServerManager();
            CloudNeoForgeEntrypoint.testClientManager();
        }
    }

    public static boolean hasServerAlreadyStarted() {
        return serverStartingCalled;
    }

    private static void registerPermissions(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{new PermissionNode("cloud", "hover-stacktrace", PermissionTypes.BOOLEAN, CloudNeoForgeEntrypoint::defaultPermissionHandler, new PermissionDynamicContextKey[0])});
        for (NeoForgeCommandManager manager : NeoForgeServerCommandManager.INSTANCES) {
            CloudNeoForgeEntrypoint.registerPermissionsForManager(event, manager);
        }
    }

    private static void registerPermissionsForManager(PermissionGatherEvent.Nodes event, NeoForgeCommandManager<?> manager) {
        HashSet<String> permissions = new HashSet<String>();
        CloudNeoForgeEntrypoint.collectPermissions(permissions, manager.commandTree().rootNodes());
        permissions.stream().filter(permissionString -> event.getNodes().stream().noneMatch(node -> node.getNodeName().equals(permissionString))).map(permissionString -> {
            int i = permissionString.indexOf(".");
            return new PermissionNode(permissionString.substring(0, i), permissionString.substring(i + 1), PermissionTypes.BOOLEAN, CloudNeoForgeEntrypoint::defaultPermissionHandler, new PermissionDynamicContextKey[0]);
        }).forEach(xva$0 -> event.addNodes(new PermissionNode[]{xva$0}));
    }

    private static <C> void collectPermissions(Set<String> permissions, Collection<CommandNode<C>> nodes) {
        for (CommandNode<C> node : nodes) {
            @Nullable Command owningCommand = node.command();
            if (owningCommand != null) {
                CloudNeoForgeEntrypoint.recurseCommandPermission(permissions, owningCommand.commandPermission());
            }
            CloudNeoForgeEntrypoint.collectPermissions(permissions, node.children());
        }
    }

    private static void recurseCommandPermission(Set<String> permissions, Permission permission) {
        if (permission instanceof PredicatePermission || permission == Permission.empty()) {
            return;
        }
        if (permission instanceof OrPermission || permission instanceof AndPermission) {
            for (Permission child : permission.permissions()) {
                CloudNeoForgeEntrypoint.recurseCommandPermission(permissions, child);
            }
        } else {
            permissions.add(permission.permissionString());
        }
    }

    private static Boolean defaultPermissionHandler(@Nullable ServerPlayer player, UUID uuid, PermissionDynamicContext<?> ... contexts) {
        return player != null && player.hasPermissions(player.getServer().getOperatorUserPermissionLevel());
    }

    private static void testClientManager() {
        NeoForgeClientCommandManager<CommandSourceStack> manager = NeoForgeClientCommandManager.createNative((ExecutionCoordinator<CommandSourceStack>)ExecutionCoordinator.simpleCoordinator());
        manager.command(manager.commandBuilder("cloud_client", new String[0]).literal("forge", new String[0]).required("string", StringParser.greedyStringParser()).handler(ctx -> ((CommandSourceStack)ctx.sender()).sendSystemMessage((Component)Component.literal((String)((String)ctx.get("string"))))));
    }

    private static void testServerManager() {
        NeoForgeServerCommandManager<CommandSourceStack> manager = NeoForgeServerCommandManager.createNative((ExecutionCoordinator<CommandSourceStack>)ExecutionCoordinator.simpleCoordinator());
        manager.command(manager.commandBuilder("cloud", new String[0]).literal("forge", new String[0]).required("string", StringParser.greedyStringParser()).permission("cloud.hello").handler(ctx -> ((CommandSourceStack)ctx.sender()).sendSystemMessage((Component)Component.literal((String)((String)ctx.get("string"))))));
    }
}

