/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.neoforge;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.SenderMapperHolder;
import org.incendo.cloud.brigadier.BrigadierManagerHolder;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.incendo.cloud.caption.CaptionFormatter;
import org.incendo.cloud.caption.CaptionProvider;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.execution.preprocessor.CommandPreprocessor;
import org.incendo.cloud.meta.CommandMeta;
import org.incendo.cloud.meta.SimpleCommandMeta;
import org.incendo.cloud.minecraft.modded.caption.MinecraftCaptionFormatter;
import org.incendo.cloud.minecraft.modded.caption.ModdedDefaultCaptionsProvider;
import org.incendo.cloud.minecraft.modded.internal.ModdedExceptionHandler;
import org.incendo.cloud.minecraft.modded.internal.ModdedParserMappings;
import org.incendo.cloud.minecraft.modded.internal.ModdedPreprocessor;
import org.incendo.cloud.neoforge.NeoForgeCommandRegistrationHandler;
import org.incendo.cloud.suggestion.SuggestionFactory;

@DefaultQualifier(value=NonNull.class)
public abstract class NeoForgeCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C, CommandSourceStack>,
SenderMapperHolder<CommandSourceStack, C> {
    static final Set<NeoForgeCommandManager<?>> INSTANCES = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final SenderMapper<CommandSourceStack, C> senderMapper;
    private final CloudBrigadierManager<C, CommandSourceStack> brigadierManager;
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    protected NeoForgeCommandManager(ExecutionCoordinator<C> executionCoordinator, SenderMapper<CommandSourceStack, C> senderMapper, NeoForgeCommandRegistrationHandler<C> registrationHandler) {
        super(executionCoordinator, registrationHandler);
        INSTANCES.add(this);
        this.senderMapper = senderMapper;
        this.suggestionFactory = super.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
        this.brigadierManager = new CloudBrigadierManager((CommandManager)this, senderMapper);
        ModdedExceptionHandler.registerDefaults((CommandManager)this, (CaptionFormatter)new MinecraftCaptionFormatter());
        registrationHandler.initialize(this);
        this.captionRegistry().registerProvider((CaptionProvider)new ModdedDefaultCaptionsProvider());
        this.registerCommandPreProcessor((CommandPreprocessor)new ModdedPreprocessor(senderMapper));
        ModdedParserMappings.register((CommandManager)this, this.brigadierManager);
    }

    public final SenderMapper<CommandSourceStack, C> senderMapper() {
        return this.senderMapper;
    }

    public final CommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.empty();
    }

    public final CloudBrigadierManager<C, CommandSourceStack> brigadierManager() {
        return this.brigadierManager;
    }

    public final boolean hasBrigadierManager() {
        return true;
    }

    public final @NonNull SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory() {
        return this.suggestionFactory;
    }

    final void registrationCalled() {
        this.lockRegistration();
    }
}

