/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.neoforge.client.ClientCommandHandler;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.brigadier.CloudBrigadierCommand;
import org.incendo.cloud.brigadier.util.BrigadierUtil;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.internal.CommandRegistrationHandler;
import org.incendo.cloud.minecraft.modded.ModdedCommandMetaKeys;
import org.incendo.cloud.minecraft.modded.internal.ContextualArgumentTypeProvider;
import org.incendo.cloud.neoforge.NeoForgeCommandManager;

abstract class NeoForgeCommandRegistrationHandler<C>
implements CommandRegistrationHandler<C> {
    private @MonotonicNonNull NeoForgeCommandManager<C> commandManager;

    NeoForgeCommandRegistrationHandler() {
    }

    void initialize(NeoForgeCommandManager<C> manager) {
        this.commandManager = manager;
    }

    NeoForgeCommandManager<C> commandManager() {
        return this.commandManager;
    }

    protected final void registerCommand(Command<C> command, CommandDispatcher<CommandSourceStack> dispatcher) {
        RootCommandNode rootNode = dispatcher.getRoot();
        CommandComponent first = command.rootComponent();
        LiteralCommandNode baseNode = this.commandManager().brigadierManager().literalBrigadierNodeFactory().createNode(first.name(), command, (com.mojang.brigadier.Command)new CloudBrigadierCommand(this.commandManager(), this.commandManager().brigadierManager()));
        rootNode.addChild((CommandNode)baseNode);
        for (String alias : first.alternativeAliases()) {
            rootNode.addChild((CommandNode)BrigadierUtil.buildRedirect((String)alias, (CommandNode)baseNode));
        }
    }

    static class Server<C>
    extends NeoForgeCommandRegistrationHandler<C> {
        private final Set<Command<C>> registeredCommands = ConcurrentHashMap.newKeySet();

        Server() {
        }

        @Override
        void initialize(NeoForgeCommandManager<C> manager) {
            super.initialize(manager);
            NeoForge.EVENT_BUS.addListener(this::registerAllCommands);
        }

        public boolean registerCommand(@NonNull Command<C> command) {
            return this.registeredCommands.add(command);
        }

        private void registerAllCommands(RegisterCommandsEvent event) {
            this.commandManager().registrationCalled();
            ContextualArgumentTypeProvider.withBuildContext(this.commandManager(), (CommandBuildContext)event.getBuildContext(), (boolean)true, () -> {
                for (Command<C> command : this.registeredCommands) {
                    Commands.CommandSelection env = (Commands.CommandSelection)command.commandMeta().getOrDefault(ModdedCommandMetaKeys.REGISTRATION_ENVIRONMENT, (Object)Commands.CommandSelection.ALL);
                    if (env == Commands.CommandSelection.INTEGRATED && !event.getCommandSelection().includeIntegrated || env == Commands.CommandSelection.DEDICATED && !event.getCommandSelection().includeDedicated) continue;
                    this.registerCommand(command, (CommandDispatcher<CommandSourceStack>)event.getDispatcher());
                }
            });
        }
    }

    static class Client<C>
    extends NeoForgeCommandRegistrationHandler<C> {
        private final Set<Command<C>> registeredCommands = ConcurrentHashMap.newKeySet();
        private volatile boolean registerEventFired = false;

        Client() {
        }

        @Override
        void initialize(NeoForgeCommandManager<C> manager) {
            super.initialize(manager);
            NeoForge.EVENT_BUS.addListener(this::registerCommands);
            NeoForge.EVENT_BUS.addListener(event -> {
                this.registerEventFired = false;
            });
        }

        public boolean registerCommand(@NonNull Command<C> command) {
            this.registeredCommands.add(command);
            if (this.registerEventFired) {
                ClientPacketListener connection = Minecraft.getInstance().getConnection();
                if (connection == null) {
                    throw new IllegalStateException("Expected connection to be present but it wasn't!");
                }
                CommandDispatcher dispatcher = ClientCommandHandler.getDispatcher();
                if (dispatcher == null) {
                    throw new IllegalStateException("Expected an active dispatcher!");
                }
                ContextualArgumentTypeProvider.withBuildContext(this.commandManager(), (CommandBuildContext)CommandBuildContext.simple((HolderLookup.Provider)connection.registryAccess(), (FeatureFlagSet)connection.enabledFeatures()), (boolean)false, () -> this.registerCommand(command, (CommandDispatcher<CommandSourceStack>)dispatcher));
            }
            return true;
        }

        public void registerCommands(RegisterClientCommandsEvent event) {
            this.registerEventFired = true;
            ContextualArgumentTypeProvider.withBuildContext(this.commandManager(), (CommandBuildContext)event.getBuildContext(), (boolean)true, () -> {
                for (Command<C> command : this.registeredCommands) {
                    this.registerCommand(command, (CommandDispatcher<CommandSourceStack>)event.getDispatcher());
                }
            });
        }
    }
}

