/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.neoforge;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.minecraft.modded.internal.ModdedParserMappings;
import org.incendo.cloud.neoforge.CloudNeoForgeEntrypoint;
import org.incendo.cloud.neoforge.NeoForgeCommandManager;
import org.incendo.cloud.neoforge.NeoForgeCommandRegistrationHandler;
import org.incendo.cloud.neoforge.PermissionNotRegisteredException;

public final class NeoForgeServerCommandManager<C>
extends NeoForgeCommandManager<C> {
    private final Cache<String, PermissionNode<Boolean>> permissionNodeCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public static NeoForgeServerCommandManager<CommandSourceStack> createNative(ExecutionCoordinator<CommandSourceStack> executionCoordinator) {
        return new NeoForgeServerCommandManager<CommandSourceStack>(executionCoordinator, SenderMapper.identity());
    }

    public NeoForgeServerCommandManager(ExecutionCoordinator<C> executionCoordinator, SenderMapper<CommandSourceStack, C> senderMapper) {
        super(executionCoordinator, senderMapper, new NeoForgeCommandRegistrationHandler.Server());
        if (CloudNeoForgeEntrypoint.hasServerAlreadyStarted()) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " was created too late! Because command registration occurs before the server instance is created, commands should be registered in mod initializers.");
        }
        ModdedParserMappings.registerServer((CommandManager)this);
    }

    public boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        CommandSourceStack source = (CommandSourceStack)this.senderMapper().reverse(sender);
        if (source.isPlayer()) {
            PermissionNode node;
            try {
                node = (PermissionNode)this.permissionNodeCache.get((Object)permission, () -> PermissionAPI.getRegisteredNodes().stream().filter(n -> n.getNodeName().equals(permission) && n.getType() == PermissionTypes.BOOLEAN).findFirst().orElseThrow(() -> new PermissionNotRegisteredException(permission)));
            }
            catch (UncheckedExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof PermissionNotRegisteredException) {
                    PermissionNotRegisteredException notRegisteredException = (PermissionNotRegisteredException)throwable;
                    throw notRegisteredException;
                }
                throw new RuntimeException("Exception location permission node " + permission, e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Exception location permission node " + permission, e);
            }
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)source.getPlayer(), (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        }
        return source.hasPermission(source.getServer().getOperatorUserPermissionLevel());
    }
}

