/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.brigadier.BrigadierManagerHolder;
import org.incendo.cloud.brigadier.BrigadierSetting;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.bukkit.BukkitCommandManager;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.bukkit.PluginHolder;
import org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperBrigadier;
import org.incendo.cloud.paper.ModernPaperBrigadier;
import org.incendo.cloud.paper.PaperCommandPreprocessor;
import org.incendo.cloud.paper.suggestion.SuggestionListener;
import org.incendo.cloud.paper.suggestion.SuggestionListenerFactory;
import org.incendo.cloud.setting.Setting;
import org.incendo.cloud.state.RegistrationState;
import org.incendo.cloud.state.State;

public class LegacyPaperCommandManager<C>
extends BukkitCommandManager<C> {
    private @Nullable BrigadierManagerHolder<C, ?> brigadierManagerHolder = null;

    @API(status=API.Status.STABLE, since="2.0.0")
    public LegacyPaperCommandManager(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<CommandSender, C> senderMapper) throws BukkitCommandManager.InitializationException {
        super(owningPlugin, commandExecutionCoordinator, senderMapper);
        this.registerCommandPreProcessor(new PaperCommandPreprocessor((PluginHolder)this, this.senderMapper(), Function.identity()));
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static @NonNull LegacyPaperCommandManager<@NonNull CommandSender> createNative(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<CommandSender> commandExecutionCoordinator) throws BukkitCommandManager.InitializationException {
        return new LegacyPaperCommandManager<CommandSender>(owningPlugin, commandExecutionCoordinator, SenderMapper.identity());
    }

    public synchronized void registerBrigadier() throws BukkitCommandManager.BrigadierInitializationException {
        this.registerBrigadier(true);
    }

    @Deprecated
    public synchronized void registerLegacyPaperBrigadier() throws BukkitCommandManager.BrigadierInitializationException {
        this.registerBrigadier(false);
    }

    private void registerBrigadier(boolean allowModern) {
        this.requireState((State)RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (this.brigadierManagerHolder != null) {
            throw new IllegalStateException("Brigadier is already registered! Holder: " + this.brigadierManagerHolder);
        }
        if (!this.hasCapability((CloudCapability)CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            super.registerBrigadier();
        } else {
            if (allowModern && CraftBukkitReflection.classExists((String)"io.papermc.paper.command.brigadier.CommandSourceStack")) {
                try {
                    ModernPaperBrigadier brig = new ModernPaperBrigadier(CommandSender.class, this, this.senderMapper(), () -> this.lockRegistration());
                    this.brigadierManagerHolder = brig;
                    brig.registerPlugin(this.owningPlugin());
                    this.commandRegistrationHandler(brig);
                }
                catch (Exception e) {
                    throw new BukkitCommandManager.BrigadierInitializationException("Failed to register ModernPaperBrigadier", (Throwable)e);
                }
            }
            try {
                this.brigadierManagerHolder = new LegacyPaperBrigadier(this);
                Bukkit.getPluginManager().registerEvents((Listener)this.brigadierManagerHolder, this.owningPlugin());
                this.brigadierManagerHolder.brigadierManager().settings().set((Setting)BrigadierSetting.FORCE_EXECUTABLE, true);
            }
            catch (Exception e) {
                throw new BukkitCommandManager.BrigadierInitializationException("Failed to register LegacyPaperBrigadier", (Throwable)e);
            }
        }
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public boolean hasBrigadierManager() {
        return this.brigadierManagerHolder != null || super.hasBrigadierManager();
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public @NonNull CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.brigadierManagerHolder != null) {
            return this.brigadierManagerHolder.brigadierManager();
        }
        return super.brigadierManager();
    }

    public void registerAsynchronousCompletions() throws IllegalStateException {
        this.requireState((State)RegistrationState.BEFORE_REGISTRATION);
        if (!this.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            throw new IllegalStateException("Failed to register asynchronous command completion listener.");
        }
        SuggestionListenerFactory suggestionListenerFactory = SuggestionListenerFactory.create(this);
        SuggestionListener suggestionListener = suggestionListenerFactory.createListener();
        Bukkit.getServer().getPluginManager().registerEvents(suggestionListener, this.owningPlugin());
    }
}

