/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import com.mojang.brigadier.Command;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandTree;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.brigadier.CloudBrigadierCommand;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.brigadier.node.LiteralBrigadierNodeFactory;
import org.incendo.cloud.brigadier.permission.BrigadierPermissionChecker;
import org.incendo.cloud.bukkit.BukkitPluginRegistrationHandler;
import org.incendo.cloud.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import org.incendo.cloud.bukkit.internal.BukkitBrigadierMapper;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.internal.CommandNode;
import org.incendo.cloud.paper.PaperBrigadierMappings;
import org.incendo.cloud.paper.PaperCommandManager;

class PaperBrigadierListener<C>
implements Listener {
    private final CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager;
    private final PaperCommandManager<C> paperCommandManager;
    private final BukkitPluginRegistrationHandler<C> registrationHandler;

    PaperBrigadierListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
        this.brigadierManager = new CloudBrigadierManager(this.paperCommandManager, () -> new CommandContext(this.paperCommandManager.senderMapper().map((Object)Bukkit.getConsoleSender()), this.paperCommandManager), SenderMapper.create(sender -> this.paperCommandManager.senderMapper().map((Object)sender.getBukkitSender()), (Function)new BukkitBackwardsBrigadierSenderMapper(this.paperCommandManager)));
        this.registrationHandler = (BukkitPluginRegistrationHandler)paperCommandManager.commandRegistrationHandler();
        BukkitBrigadierMapper mapper = new BukkitBrigadierMapper(this.paperCommandManager, this.brigadierManager);
        mapper.registerBuiltInMappings();
        PaperBrigadierMappings.register(mapper);
    }

    protected @NonNull CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager() {
        return this.brigadierManager;
    }

    @EventHandler
    public void onCommandRegister(@NonNull CommandRegisteredEvent<BukkitBrigadierCommandSource> event) {
        String label;
        if (!(event.getCommand() instanceof PluginIdentifiableCommand)) {
            return;
        }
        if (!((PluginIdentifiableCommand)event.getCommand()).getPlugin().equals(this.paperCommandManager.owningPlugin())) {
            return;
        }
        CommandTree commandTree = this.paperCommandManager.commandTree();
        CommandNode node = commandTree.getNamedNode(label = event.getCommandLabel().contains(":") ? event.getCommandLabel().split(Pattern.quote(":"))[1] : event.getCommandLabel());
        if (node == null) {
            return;
        }
        BrigadierPermissionChecker permissionChecker = (sender, permission) -> {
            if (commandTree.getNamedNode(label) == null) {
                return false;
            }
            return this.paperCommandManager.testPermission(sender, permission).allowed();
        };
        LiteralBrigadierNodeFactory literalFactory = this.brigadierManager.literalBrigadierNodeFactory();
        event.setLiteral(literalFactory.createNode(event.getLiteral().getLiteral(), node, (Command)new CloudBrigadierCommand(this.paperCommandManager, this.brigadierManager, this::stripNamespace), permissionChecker));
    }

    private String stripNamespace(String command) {
        CharSequence[] split = command.split(" ");
        if (!split[0].contains(":")) {
            return command;
        }
        String token = split[0];
        String[] splitToken = token.split(":");
        if (this.registrationHandler.getNamespacedLabel(splitToken[1]).equals(token)) {
            split[0] = splitToken[1];
            return String.join((CharSequence)" ", split);
        }
        return command;
    }
}

