/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper;

import java.util.concurrent.Executor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.bukkit.BukkitCommandContextKeys;
import org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import org.incendo.cloud.execution.preprocessor.CommandPreprocessingContext;
import org.incendo.cloud.execution.preprocessor.CommandPreprocessor;
import org.incendo.cloud.paper.PaperCommandManager;

final class PaperCommandPreprocessor<C>
implements CommandPreprocessor<C> {
    private static final boolean FOLIA = CraftBukkitReflection.classExists((String)"io.papermc.paper.threadedregions.RegionizedServer");
    private final PaperCommandManager<C> manager;

    PaperCommandPreprocessor(PaperCommandManager<C> manager) {
        this.manager = manager;
    }

    public void accept(CommandPreprocessingContext<C> ctx) {
        if (FOLIA) {
            ctx.commandContext().store(BukkitCommandContextKeys.SENDER_SCHEDULER_EXECUTOR, (Object)this.foliaExecutorFor(ctx.commandContext().sender()));
        }
    }

    private Executor foliaExecutorFor(C sender) {
        CommandSender commandSender = (CommandSender)this.manager.senderMapper().reverse(sender);
        Plugin plugin = this.manager.owningPlugin();
        if (commandSender instanceof Entity) {
            return task -> ((Entity)commandSender).getScheduler().run(plugin, handle -> task.run(), null);
        }
        if (commandSender instanceof BlockCommandSender) {
            BlockCommandSender blockSender = (BlockCommandSender)commandSender;
            return task -> blockSender.getServer().getRegionScheduler().run(plugin, blockSender.getBlock().getLocation(), handle -> task.run());
        }
        return task -> plugin.getServer().getGlobalRegionScheduler().run(plugin, handle -> task.run());
    }
}

