/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper.suggestion;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.paper.PaperCommandManager;
import org.incendo.cloud.paper.suggestion.AsyncCommandSuggestionListener;
import org.incendo.cloud.paper.suggestion.tooltips.CompletionMapper;
import org.incendo.cloud.paper.suggestion.tooltips.CompletionMapperFactory;
import org.incendo.cloud.suggestion.SuggestionFactory;
import org.incendo.cloud.suggestion.Suggestions;
import org.incendo.cloud.util.StringUtils;

class BrigadierAsyncCommandSuggestionListener<C>
extends AsyncCommandSuggestionListener<C> {
    private final CompletionMapperFactory completionMapperFactory = CompletionMapperFactory.detectingRelocation();
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    BrigadierAsyncCommandSuggestionListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        super(paperCommandManager);
        this.suggestionFactory = paperCommandManager.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
    }

    @Override
    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        super.onTabCompletion(event);
    }

    @Override
    protected Suggestions<C, ? extends TooltipSuggestion> querySuggestions(@NonNull C commandSender, @NonNull String input) {
        return this.suggestionFactory.suggestImmediately(commandSender, input);
    }

    @Override
    protected void setSuggestions(@NonNull AsyncTabCompleteEvent event, @NonNull C commandSender, @NonNull String input) {
        CompletionMapper completionMapper = this.completionMapperFactory.createMapper();
        Suggestions suggestions = this.querySuggestions(commandSender, input);
        event.completions(suggestions.list().stream().map(suggestion -> {
            @Nullable String trim = StringUtils.trimBeforeLastSpace((String)suggestion.suggestion(), (CommandInput)suggestions.commandInput());
            if (trim == null) {
                return null;
            }
            return suggestion.withSuggestion(trim);
        }).filter(Objects::nonNull).map(completionMapper::map).collect(Collectors.toList()));
    }
}

