/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.velocity;

import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.brigadier.CloudBrigadierCommand;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.internal.CommandRegistrationHandler;
import org.incendo.cloud.velocity.VelocityCommandManager;

final class VelocityPluginRegistrationHandler<C>
implements CommandRegistrationHandler<C> {
    private CloudBrigadierManager<C, CommandSource> brigadierManager;
    private VelocityCommandManager<C> manager;

    VelocityPluginRegistrationHandler() {
    }

    void initialize(@NonNull VelocityCommandManager<C> velocityCommandManager) {
        this.manager = velocityCommandManager;
        this.brigadierManager = new CloudBrigadierManager(velocityCommandManager, velocityCommandManager.senderMapper());
    }

    public boolean registerCommand(@NonNull Command<C> command) {
        CommandComponent component = command.rootComponent();
        Collection aliases = component.alternativeAliases();
        BrigadierCommand brigadierCommand = new BrigadierCommand(this.brigadierManager.literalBrigadierNodeFactory().createNode(command.rootComponent().name(), command, (com.mojang.brigadier.Command)new CloudBrigadierCommand(this.manager, this.brigadierManager)));
        CommandMeta commandMeta = this.manager.proxyServer().getCommandManager().metaBuilder(brigadierCommand).aliases(aliases.toArray(new String[0])).build();
        aliases.forEach(arg_0 -> ((CommandManager)this.manager.proxyServer().getCommandManager()).unregister(arg_0));
        this.manager.proxyServer().getCommandManager().register(commandMeta, (com.velocitypowered.api.command.Command)brigadierCommand);
        return true;
    }

    @NonNull CloudBrigadierManager<C, CommandSource> brigadierManager() {
        return this.brigadierManager;
    }
}

