/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.velocity.parser;

import com.mojang.brigadier.Message;
import com.velocitypowered.api.command.VelocityBrigadierMessage;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.velocity.VelocityCaptionKeys;
import org.incendo.cloud.velocity.VelocityContextKeys;

public final class PlayerParser<C>
implements ArgumentParser<C, Player>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Player> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), Player.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, Player> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    public @NonNull ArgumentParseResult<@NonNull Player> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Player player = ((ProxyServer)commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY)).getPlayer(input).orElse(null);
        if (player == null) {
            return ArgumentParseResult.failure((Throwable)((Object)new PlayerParseException(input, commandContext)));
        }
        return ArgumentParseResult.success((Object)player);
    }

    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return ((ProxyServer)commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY)).getAllPlayers().stream().map(player -> TooltipSuggestion.suggestion((String)player.getUsername(), (Message)VelocityBrigadierMessage.tooltip((Component)Component.text((String)player.getUniqueId().toString())))).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }
}

