/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.velocity.parser;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.velocity.VelocityCaptionKeys;
import org.incendo.cloud.velocity.VelocityContextKeys;

public final class ServerParser<C>
implements ArgumentParser<C, RegisteredServer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, RegisteredServer> serverParser() {
        return ParserDescriptor.of(new ServerParser<C>(), RegisteredServer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, RegisteredServer> serverComponent() {
        return CommandComponent.builder().parser(ServerParser.serverParser());
    }

    public @NonNull ArgumentParseResult<@NonNull RegisteredServer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        RegisteredServer server = ((ProxyServer)commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY)).getServer(input).orElse(null);
        if (server == null) {
            return ArgumentParseResult.failure((Throwable)((Object)new ServerParseException(input, commandContext)));
        }
        return ArgumentParseResult.success((Object)server);
    }

    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return ((ProxyServer)commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY)).getAllServers().stream().map(s -> s.getServerInfo().getName()).collect(Collectors.toList());
    }

    public static final class ServerParseException
    extends ParserException {
        private ServerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(ServerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }
}

