package org.indunet.fastproto.annotation.type;

import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.decoder.UInteger8Decoder;
import org.indunet.fastproto.encoder.UInteger8Encoder;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Integer type, corresponding to Java Integer/int.
 *
 * @author Deng Ran
 * @see Type
 * @since 1.2.0
 */
@Type
@Decoder(UInteger8Decoder.class)
@Encoder(UInteger8Encoder.class)
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface UInteger8Type {
    int SIZE = Byte.SIZE >> 3;
    int MAX_VALUE = Byte.MAX_VALUE - Byte.MIN_VALUE;
    int MIN_VALUE = 0;

    int value();
}
