/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.DecodeFormula;
import org.indunet.fastproto.annotation.DecodeIgnore;
import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.EncodeFormula;
import org.indunet.fastproto.annotation.EncodeIgnore;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.EncodeException;

public class TypeAssist {
    TypeAssist parent;
    Class<?> type;
    Field field;
    Annotation dataType;
    EndianPolicy endianPolicy;
    Boolean decodeIgnore;
    Boolean encodeIgnore;
    ElementType elementType;
    List<TypeAssist> elements;
    Class<? extends TypeDecoder> decoderClass;
    Class<? extends TypeEncoder> encoderClass;
    Class<? extends Function> decodeFormula;
    Class<? extends Function> encodeFormula;
    Function<DecodeContext, ?> decoder;
    Consumer<?> encoder;

    protected TypeAssist() {
    }

    public static TypeAssist of(Class<?> clazz) {
        Predicate<Field> isType = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(Type.class));
        Stream<TypeAssist> typeStream = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType.negate()).map(f -> {
            f.setAccessible(true);
            Class<?> c = f.getType();
            TypeAssist a = TypeAssist.of(c);
            Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
            Boolean encodeIgnore = f.isAnnotationPresent(EncodeIgnore.class);
            a.setDecodeIgnore(decodeIgnore);
            a.setEncodeIgnore(encodeIgnore);
            a.setField((Field)f);
            return a;
        }).filter(TypeAssist::hasElement);
        EndianPolicy endianPolicy = Optional.ofNullable(clazz.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        Boolean decodeIgnore = clazz.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = clazz.isAnnotationPresent(EncodeIgnore.class);
        Stream<TypeAssist> fieldStream = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType).peek(f -> f.setAccessible(true)).map(TypeAssist::of).peek(a -> {
            if (a.getEndianPolicy() == null) {
                a.setEndianPolicy(endianPolicy);
            }
        });
        TypeAssist assist = TypeAssist.builder().type(clazz).field(null).dataType(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(endianPolicy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.TYPE).build();
        List<TypeAssist> elements = Stream.concat(fieldStream, typeStream).peek(a -> a.setParent(assist)).collect(Collectors.toList());
        assist.setElements(elements);
        return assist;
    }

    protected static TypeAssist of(Field field) {
        EndianPolicy policy = Optional.ofNullable(field.getAnnotation(Endian.class)).map(Endian::value).orElse(null);
        Boolean decodeIgnore = field.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = field.isAnnotationPresent(EncodeIgnore.class);
        Annotation dataType = Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(Type.class)).findAny().orElseThrow(CodecException::new);
        Class decoder = Optional.of(dataType).map(Annotation::annotationType).map(t -> t.getAnnotation(Decoder.class)).map(Decoder::value).orElse(null);
        Class encoder = Optional.of(dataType).map(Annotation::annotationType).map(t -> t.getAnnotation(Encoder.class)).map(Encoder::value).orElse(null);
        Class decodeFormula = Optional.ofNullable(field.getAnnotation(DecodeFormula.class)).map(DecodeFormula::value).orElse(null);
        Class encodeFormula = Optional.ofNullable(field.getAnnotation(EncodeFormula.class)).map(EncodeFormula::value).orElse(null);
        return TypeAssist.builder().type(field.getType()).field(field).dataType(dataType).decoderClass(decoder).encoderClass(encoder).decodeFormula(decodeFormula).encodeFormula(encodeFormula).endianPolicy(policy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.FIELD).build();
    }

    public boolean hasElement() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_ASSIGN_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    protected DecodeContext toDecodeContext(byte[] datagram, Object object) {
        return DecodeContext.builder().object(object).datagram(datagram).typeAssist(this).build();
    }

    protected List<DecodeContext> toDecodeContexts(byte[] datagram, Object object) {
        try {
            Object value = this.type.newInstance();
            if (object != null && this.field != null) {
                try {
                    this.field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            Stream<DecodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toDecodeContext(datagram, value));
            Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> a.toDecodeContexts(datagram, value).stream());
            return Stream.concat(fieldStream, classStream).collect(Collectors.toList());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_INITIALIZING_DECODE_OBJECT.getMessage(), this.type.getName()), (Throwable)e);
        }
    }

    public List<DecodeContext> toDecodeContexts(byte[] datagram) {
        return this.toDecodeContexts(datagram, null);
    }

    public EncodeContext toEncodeContext(Object object, byte[] datagram) {
        try {
            return EncodeContext.builder().datagram(datagram).typeAssist(this).value(this.field.get(object)).build();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    public List<EncodeContext> toEncodeContexts(Object object, byte[] datagram) {
        Stream<EncodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toEncodeContext(object, datagram));
        Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> {
            try {
                if (object != null && a.field.get(object) != null) {
                    return a.toEncodeContexts(a.field.get(object), datagram).stream();
                }
                return Stream.empty();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new DecodeException(MessageFormat.format(EncodeException.EncodeError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.type.getName()), (Throwable)e);
            }
        });
        return Stream.concat(fieldStream, classStream).filter(c -> c.getValue() != null).collect(Collectors.toList());
    }

    public static TypeAssistBuilder builder() {
        return new TypeAssistBuilder();
    }

    public TypeAssist getParent() {
        return this.parent;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getDataType() {
        return this.dataType;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodeIgnore() {
        return this.decodeIgnore;
    }

    public Boolean getEncodeIgnore() {
        return this.encodeIgnore;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public List<TypeAssist> getElements() {
        return this.elements;
    }

    public Class<? extends TypeDecoder> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends TypeEncoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Function> getDecodeFormula() {
        return this.decodeFormula;
    }

    public Class<? extends Function> getEncodeFormula() {
        return this.encodeFormula;
    }

    public Function<DecodeContext, ?> getDecoder() {
        return this.decoder;
    }

    public Consumer<?> getEncoder() {
        return this.encoder;
    }

    public void setParent(TypeAssist parent) {
        this.parent = parent;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setDataType(Annotation dataType) {
        this.dataType = dataType;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodeIgnore(Boolean decodeIgnore) {
        this.decodeIgnore = decodeIgnore;
    }

    public void setEncodeIgnore(Boolean encodeIgnore) {
        this.encodeIgnore = encodeIgnore;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public void setElements(List<TypeAssist> elements) {
        this.elements = elements;
    }

    public void setDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        this.decoderClass = decoderClass;
    }

    public void setEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        this.encoderClass = encoderClass;
    }

    public void setDecodeFormula(Class<? extends Function> decodeFormula) {
        this.decodeFormula = decodeFormula;
    }

    public void setEncodeFormula(Class<? extends Function> encodeFormula) {
        this.encodeFormula = encodeFormula;
    }

    public void setDecoder(Function<DecodeContext, ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Consumer<?> encoder) {
        this.encoder = encoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeAssist)) {
            return false;
        }
        TypeAssist other = (TypeAssist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$decodeIgnore = this.getDecodeIgnore();
        Boolean other$decodeIgnore = other.getDecodeIgnore();
        if (this$decodeIgnore == null ? other$decodeIgnore != null : !((Object)this$decodeIgnore).equals(other$decodeIgnore)) {
            return false;
        }
        Boolean this$encodeIgnore = this.getEncodeIgnore();
        Boolean other$encodeIgnore = other.getEncodeIgnore();
        if (this$encodeIgnore == null ? other$encodeIgnore != null : !((Object)this$encodeIgnore).equals(other$encodeIgnore)) {
            return false;
        }
        TypeAssist this$parent = this.getParent();
        TypeAssist other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        Annotation this$dataType = this.getDataType();
        Annotation other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        EndianPolicy this$endianPolicy = this.getEndianPolicy();
        EndianPolicy other$endianPolicy = other.getEndianPolicy();
        if (this$endianPolicy == null ? other$endianPolicy != null : !((Object)((Object)this$endianPolicy)).equals((Object)other$endianPolicy)) {
            return false;
        }
        ElementType this$elementType = this.getElementType();
        ElementType other$elementType = other.getElementType();
        if (this$elementType == null ? other$elementType != null : !((Object)((Object)this$elementType)).equals((Object)other$elementType)) {
            return false;
        }
        List<TypeAssist> this$elements = this.getElements();
        List<TypeAssist> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Class<? extends TypeDecoder> this$decoderClass = this.getDecoderClass();
        Class<? extends TypeDecoder> other$decoderClass = other.getDecoderClass();
        if (this$decoderClass == null ? other$decoderClass != null : !this$decoderClass.equals(other$decoderClass)) {
            return false;
        }
        Class<? extends TypeEncoder> this$encoderClass = this.getEncoderClass();
        Class<? extends TypeEncoder> other$encoderClass = other.getEncoderClass();
        if (this$encoderClass == null ? other$encoderClass != null : !this$encoderClass.equals(other$encoderClass)) {
            return false;
        }
        Class<? extends Function> this$decodeFormula = this.getDecodeFormula();
        Class<? extends Function> other$decodeFormula = other.getDecodeFormula();
        if (this$decodeFormula == null ? other$decodeFormula != null : !this$decodeFormula.equals(other$decodeFormula)) {
            return false;
        }
        Class<? extends Function> this$encodeFormula = this.getEncodeFormula();
        Class<? extends Function> other$encodeFormula = other.getEncodeFormula();
        if (this$encodeFormula == null ? other$encodeFormula != null : !this$encodeFormula.equals(other$encodeFormula)) {
            return false;
        }
        Function<DecodeContext, ?> this$decoder = this.getDecoder();
        Function<DecodeContext, ?> other$decoder = other.getDecoder();
        if (this$decoder == null ? other$decoder != null : !this$decoder.equals(other$decoder)) {
            return false;
        }
        Consumer<?> this$encoder = this.getEncoder();
        Consumer<?> other$encoder = other.getEncoder();
        return !(this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypeAssist;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $decodeIgnore = this.getDecodeIgnore();
        result = result * 59 + ($decodeIgnore == null ? 43 : ((Object)$decodeIgnore).hashCode());
        Boolean $encodeIgnore = this.getEncodeIgnore();
        result = result * 59 + ($encodeIgnore == null ? 43 : ((Object)$encodeIgnore).hashCode());
        TypeAssist $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        Annotation $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        EndianPolicy $endianPolicy = this.getEndianPolicy();
        result = result * 59 + ($endianPolicy == null ? 43 : ((Object)((Object)$endianPolicy)).hashCode());
        ElementType $elementType = this.getElementType();
        result = result * 59 + ($elementType == null ? 43 : ((Object)((Object)$elementType)).hashCode());
        List<TypeAssist> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        Class<? extends TypeDecoder> $decoderClass = this.getDecoderClass();
        result = result * 59 + ($decoderClass == null ? 43 : $decoderClass.hashCode());
        Class<? extends TypeEncoder> $encoderClass = this.getEncoderClass();
        result = result * 59 + ($encoderClass == null ? 43 : $encoderClass.hashCode());
        Class<? extends Function> $decodeFormula = this.getDecodeFormula();
        result = result * 59 + ($decodeFormula == null ? 43 : $decodeFormula.hashCode());
        Class<? extends Function> $encodeFormula = this.getEncodeFormula();
        result = result * 59 + ($encodeFormula == null ? 43 : $encodeFormula.hashCode());
        Function<DecodeContext, ?> $decoder = this.getDecoder();
        result = result * 59 + ($decoder == null ? 43 : $decoder.hashCode());
        Consumer<?> $encoder = this.getEncoder();
        result = result * 59 + ($encoder == null ? 43 : $encoder.hashCode());
        return result;
    }

    public TypeAssist(TypeAssist parent, Class<?> type, Field field, Annotation dataType, EndianPolicy endianPolicy, Boolean decodeIgnore, Boolean encodeIgnore, ElementType elementType, List<TypeAssist> elements, Class<? extends TypeDecoder> decoderClass, Class<? extends TypeEncoder> encoderClass, Class<? extends Function> decodeFormula, Class<? extends Function> encodeFormula, Function<DecodeContext, ?> decoder, Consumer<?> encoder) {
        this.parent = parent;
        this.type = type;
        this.field = field;
        this.dataType = dataType;
        this.endianPolicy = endianPolicy;
        this.decodeIgnore = decodeIgnore;
        this.encodeIgnore = encodeIgnore;
        this.elementType = elementType;
        this.elements = elements;
        this.decoderClass = decoderClass;
        this.encoderClass = encoderClass;
        this.decodeFormula = decodeFormula;
        this.encodeFormula = encodeFormula;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public String toString() {
        return "TypeAssist(type=" + this.getType() + ", field=" + this.getField() + ", dataType=" + this.getDataType() + ", endianPolicy=" + (Object)((Object)this.getEndianPolicy()) + ", decodeIgnore=" + this.getDecodeIgnore() + ", encodeIgnore=" + this.getEncodeIgnore() + ", elementType=" + (Object)((Object)this.getElementType()) + ", elements=" + this.getElements() + ", decoderClass=" + this.getDecoderClass() + ", encoderClass=" + this.getEncoderClass() + ", decodeFormula=" + this.getDecodeFormula() + ", encodeFormula=" + this.getEncodeFormula() + ", decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ")";
    }

    public static class TypeAssistBuilder {
        private TypeAssist parent;
        private Class<?> type;
        private Field field;
        private Annotation dataType;
        private EndianPolicy endianPolicy;
        private Boolean decodeIgnore;
        private Boolean encodeIgnore;
        private ElementType elementType;
        private List<TypeAssist> elements;
        private Class<? extends TypeDecoder> decoderClass;
        private Class<? extends TypeEncoder> encoderClass;
        private Class<? extends Function> decodeFormula;
        private Class<? extends Function> encodeFormula;
        private Function<DecodeContext, ?> decoder;
        private Consumer<?> encoder;

        TypeAssistBuilder() {
        }

        public TypeAssistBuilder parent(TypeAssist parent) {
            this.parent = parent;
            return this;
        }

        public TypeAssistBuilder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public TypeAssistBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public TypeAssistBuilder dataType(Annotation dataType) {
            this.dataType = dataType;
            return this;
        }

        public TypeAssistBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public TypeAssistBuilder decodeIgnore(Boolean decodeIgnore) {
            this.decodeIgnore = decodeIgnore;
            return this;
        }

        public TypeAssistBuilder encodeIgnore(Boolean encodeIgnore) {
            this.encodeIgnore = encodeIgnore;
            return this;
        }

        public TypeAssistBuilder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public TypeAssistBuilder elements(List<TypeAssist> elements) {
            this.elements = elements;
            return this;
        }

        public TypeAssistBuilder decoderClass(Class<? extends TypeDecoder> decoderClass) {
            this.decoderClass = decoderClass;
            return this;
        }

        public TypeAssistBuilder encoderClass(Class<? extends TypeEncoder> encoderClass) {
            this.encoderClass = encoderClass;
            return this;
        }

        public TypeAssistBuilder decodeFormula(Class<? extends Function> decodeFormula) {
            this.decodeFormula = decodeFormula;
            return this;
        }

        public TypeAssistBuilder encodeFormula(Class<? extends Function> encodeFormula) {
            this.encodeFormula = encodeFormula;
            return this;
        }

        public TypeAssistBuilder decoder(Function<DecodeContext, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TypeAssistBuilder encoder(Consumer<?> encoder) {
            this.encoder = encoder;
            return this;
        }

        public TypeAssist build() {
            return new TypeAssist(this.parent, this.type, this.field, this.dataType, this.endianPolicy, this.decodeIgnore, this.encodeIgnore, this.elementType, this.elements, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder);
        }

        public String toString() {
            return "TypeAssist.TypeAssistBuilder(parent=" + this.parent + ", type=" + this.type + ", field=" + this.field + ", dataType=" + this.dataType + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodeIgnore=" + this.decodeIgnore + ", encodeIgnore=" + this.encodeIgnore + ", elementType=" + (Object)((Object)this.elementType) + ", elements=" + this.elements + ", decoderClass=" + this.decoderClass + ", encoderClass=" + this.encoderClass + ", decodeFormula=" + this.decodeFormula + ", encodeFormula=" + this.encodeFormula + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ")";
        }
    }
}

