/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.Timestamp;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.IntegerType;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimestampType;

@Target(value={ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Type {
    public int value() default -1;

    public static enum DataType {
        BINARY_TYPE(BinaryType.class, byte[].class),
        BOOLEAN_TYPE(BooleanType.class, Boolean.class),
        BYTE_TYPE(ByteType.class, Byte.class),
        DOUBLE_TYPE(DoubleType.class, Double.class),
        FLOAT_TYPE(FloatType.class, Float.class),
        INTEGER_TYPE(IntegerType.class, Integer.class),
        LONG_TYPE(LongType.class, Long.class),
        SHORT_TYPE(ShortType.class, Short.class),
        STRING_TYPE(StringType.class, String.class),
        TIMESTAMP_TYPE(TimestampType.class, Timestamp.class);

        Class<? extends Annotation> type;
        Class<?> javaType;

        private DataType(Class<? extends Annotation> type, Class<?> javaType) {
            this.type = type;
            this.javaType = javaType;
        }

        public Class<? extends Annotation> getType() {
            return this.type;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }
    }
}

