/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class BinaryDecoder
implements TypeDecoder<byte[]> {
    @Override
    public byte[] decode(DecodeContext context) {
        BinaryType type = context.getDataType(BinaryType.class);
        return this.decode(context.getDatagram(), type.byteOffset(), type.length());
    }

    public byte[] decode(byte[] datagram, int byteOffset, int length) {
        if (byteOffset + length > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE, (Throwable)new ArrayIndexOutOfBoundsException());
        }
        byte[] bytes = new byte[length];
        System.arraycopy(datagram, byteOffset, bytes, 0, length);
        return bytes;
    }
}

