/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class BooleanDecoder
implements TypeDecoder<Boolean> {
    @Override
    public Boolean decode(DecodeContext context) {
        BooleanType type = context.getDataType(BooleanType.class);
        return this.decode(context.getDatagram(), type.byteOffset(), type.bitOffset());
    }

    public boolean decode(byte[] datagram, int byteOffset, int bitOffset) {
        if (bitOffset > 7 || bitOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BIT_OFFSET);
        }
        if (byteOffset >= datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        return (datagram[byteOffset] & 1 << bitOffset) != 0;
    }
}

