/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class DoubleDecoder
implements TypeDecoder<Double> {
    @Override
    public Double decode(DecodeContext context) {
        DoubleType type = context.getDataType(DoubleType.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public double decode(byte[] datagram, int byteOffset, EndianPolicy endian) {
        if (byteOffset + 8 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        long value = 0L;
        if (endian == EndianPolicy.LITTLE) {
            value |= (long)datagram[byteOffset] & 0xFFL;
            value |= ((long)datagram[byteOffset + 1] & 0xFFL) << 8;
            value |= ((long)datagram[byteOffset + 2] & 0xFFL) << 16;
            value |= ((long)datagram[byteOffset + 3] & 0xFFL) << 24;
            value |= ((long)datagram[byteOffset + 4] & 0xFFL) << 32;
            value |= ((long)datagram[byteOffset + 5] & 0xFFL) << 40;
            value |= ((long)datagram[byteOffset + 6] & 0xFFL) << 48;
            value |= ((long)datagram[byteOffset + 7] & 0xFFL) << 56;
        } else if (endian == EndianPolicy.BIG) {
            value |= (long)datagram[byteOffset + 7] & 0xFFL;
            value |= ((long)datagram[byteOffset + 6] & 0xFFL) << 8;
            value |= ((long)datagram[byteOffset + 5] & 0xFFL) << 16;
            value |= ((long)datagram[byteOffset + 4] & 0xFFL) << 24;
            value |= ((long)datagram[byteOffset + 3] & 0xFFL) << 32;
            value |= ((long)datagram[byteOffset + 2] & 0xFFL) << 40;
            value |= ((long)datagram[byteOffset + 1] & 0xFFL) << 48;
            value |= ((long)datagram[byteOffset] & 0xFFL) << 56;
        }
        return Double.longBitsToDouble(value);
    }
}

