/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class ShortDecoder
implements TypeDecoder<Short> {
    @Override
    public Short decode(DecodeContext context) {
        ShortType type = context.getDataType(ShortType.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public short decode(byte[] datagram, int byteOffset, EndianPolicy endian) {
        if (byteOffset + 2 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        short value = 0;
        if (endian == EndianPolicy.LITTLE) {
            value = (short)(value | datagram[byteOffset] & 0xFF);
            value = (short)(value | datagram[byteOffset + 1] << 8);
        } else if (endian == EndianPolicy.BIG) {
            value = (short)(value | datagram[byteOffset + 1] & 0xFF);
            value = (short)(value | datagram[byteOffset] << 8);
        }
        return value;
    }
}

