/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class StringDecoder
implements TypeDecoder<String> {
    @Override
    public String decode(DecodeContext context) {
        StringType type = context.getDataType(StringType.class);
        return this.decode(context.getDatagram(), type.byteOffset(), type.length(), Charset.forName(type.charsetName()));
    }

    public String decode(byte[] datagram, int byteOffset, int length, Charset charset) {
        if (length == -1) {
            if (datagram.length - byteOffset > 0) {
                return new String(Arrays.copyOfRange(datagram, byteOffset, datagram.length - byteOffset), charset);
            }
            return "";
        }
        if (byteOffset + length > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        return new String(Arrays.copyOfRange(datagram, byteOffset, byteOffset + length), charset);
    }
}

