/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.util.DecodeUtils;

public class TimestampDecoder
implements TypeDecoder<Timestamp> {
    @Override
    public Timestamp decode(DecodeContext context) {
        EndianPolicy policy = context.getEndianPolicy();
        TimestampType type = context.getDataType(TimestampType.class);
        Type.DataType dataType = type.dataType();
        return this.decode(context.getDatagram(), type.value(), dataType, policy, type.unit());
    }

    public Timestamp decode(byte[] datagram, int byteOffset, Type.DataType dataType, EndianPolicy policy, TimeUnit unit) {
        if (dataType == Type.DataType.LONG_TYPE && unit == TimeUnit.MILLISECONDS) {
            if (byteOffset + 8 > datagram.length) {
                throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            long value = DecodeUtils.longType(datagram, byteOffset);
            return new Timestamp(value);
        }
        if (dataType == Type.DataType.INTEGER_TYPE && unit == TimeUnit.SECONDS) {
            if (byteOffset + 4 > datagram.length) {
                throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            int value = DecodeUtils.integerType(datagram, byteOffset);
            return new Timestamp(value * 1000);
        }
        throw new DecodeException(DecodeException.DecodeError.ILLEGAL_TIMESTAMP_PARAMETERS);
    }
}

