/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger16Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class UInteger16Decoder
implements TypeDecoder<Integer> {
    @Override
    public Integer decode(DecodeContext context) {
        UInteger16Type type = context.getDataType(UInteger16Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(context.getDatagram(), type.value(), policy);
    }

    public int decode(byte[] datagram, int byteOffset, EndianPolicy policy) {
        if (byteOffset + 2 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.BIG) {
            return (datagram[byteOffset] & 0xFF) * 256 + (datagram[byteOffset + 1] & 0xFF);
        }
        return (datagram[byteOffset + 1] & 0xFF) * 256 + (datagram[byteOffset] & 0xFF);
    }
}

