/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger32Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class UInteger32Decoder
implements TypeDecoder<Long> {
    @Override
    public Long decode(DecodeContext context) {
        UInteger32Type type = context.getDataType(UInteger32Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(context.getDatagram(), type.value(), policy);
    }

    public long decode(byte[] datagram, int byteOffset, EndianPolicy policy) {
        if (byteOffset + 4 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        long value = 0L;
        if (policy == EndianPolicy.LITTLE) {
            value |= (long)(datagram[byteOffset] & 0xFF);
            value |= ((long)datagram[byteOffset + 1] & 0xFFL) << 8;
            value |= ((long)datagram[byteOffset + 2] & 0xFFL) << 16;
            value |= ((long)datagram[byteOffset + 3] & 0xFFL) << 24;
        } else if (policy == EndianPolicy.BIG) {
            value |= (long)(datagram[byteOffset + 3] & 0xFF);
            value |= ((long)datagram[byteOffset + 2] & 0xFFL) << 8;
            value |= ((long)datagram[byteOffset + 1] & 0xFFL) << 16;
            value |= ((long)datagram[byteOffset] & 0xFFL) << 24;
        }
        return value;
    }
}

