/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class BinaryEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        BinaryType type = context.getDataType(BinaryType.class);
        byte[] bytes = context.getValue(byte[].class);
        this.encode(context.getDatagram(), type.byteOffset(), bytes);
    }

    public void encode(byte[] datagram, int byteOffset, byte[] bytes) {
        if (byteOffset + bytes.length > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        System.arraycopy(bytes, 0, datagram, byteOffset, bytes.length);
    }
}

