/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.Integer16Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class Integer16Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        Integer16Type type = context.getDataType(Integer16Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.value(), policy, value);
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy policy, int value) {
        if (byteOffset + 2 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.EXCEEDED_TYPE_SIZE_LIMIT.getMessage(), Integer16Type.class.getName()));
        }
        if (policy == EndianPolicy.BIG) {
            datagram[byteOffset + 1] = (byte)(value & 0xFF);
            datagram[byteOffset] = (byte)(value >> 8 & 0xFF);
        } else {
            datagram[byteOffset] = (byte)(value & 0xFF);
            datagram[byteOffset + 1] = (byte)(value >> 8 & 0xFF);
        }
    }
}

