/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import org.indunet.fastproto.annotation.type.Integer8Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class Integer8Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        Integer8Type type = context.getDataType(Integer8Type.class);
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.value(), value);
    }

    public void encode(byte[] datagram, int byteOffset, int value) {
        if (byteOffset + 1 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (value > 127 || value < -128) {
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.EXCEEDED_TYPE_SIZE_LIMIT.getMessage(), Integer8Type.class.getName()));
        }
        datagram[byteOffset] = (byte)value;
    }
}

