/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.nio.charset.Charset;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class StringEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        StringType dataType = context.getDataType(StringType.class);
        String value = context.getValue(String.class);
        this.encode(context.getDatagram(), dataType.byteOffset(), dataType.length(), Charset.defaultCharset(), value);
    }

    public void encode(byte[] datagram, int byteOffset, int length, Charset set, String value) {
        byte[] bytes = value.getBytes(set);
        if (length == -1) {
            System.arraycopy(bytes, 0, datagram, byteOffset, bytes.length);
        } else {
            if (byteOffset + length > datagram.length) {
                throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            System.arraycopy(bytes, 0, datagram, byteOffset, length);
        }
    }
}

