/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.util.EncodeUtils;

public class TimestampEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        EndianPolicy policy = context.getEndianPolicy();
        TimestampType type = context.getDataType(TimestampType.class);
        Timestamp value = context.getValue(Timestamp.class);
        this.encode(context.getDatagram(), type.value(), type.dataType(), policy, type.unit(), value);
    }

    public void encode(byte[] datagram, int byteOffset, Type.DataType dataType, EndianPolicy policy, TimeUnit unit, Timestamp value) {
        if (dataType == Type.DataType.LONG_TYPE && unit == TimeUnit.MILLISECONDS) {
            if (byteOffset + 8 > datagram.length) {
                throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            EncodeUtils.longType(datagram, byteOffset, policy, value.getTime());
        } else if (dataType == Type.DataType.INTEGER_TYPE && unit == TimeUnit.SECONDS) {
            if (byteOffset + 4 > datagram.length) {
                throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            EncodeUtils.integerType(datagram, byteOffset, policy, (int)(value.getTime() / 1000L));
        } else {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_TIMESTAMP_PARAMETERS);
        }
    }
}

