/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger8Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class UInteger8Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        UInteger8Type type = context.getDataType(UInteger8Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.value(), value);
    }

    public void encode(byte[] datagram, int byteOffset, int value) {
        if (byteOffset + 1 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (value > 255 || value < 0) {
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.EXCEEDED_TYPE_SIZE_LIMIT.getMessage(), UInteger8Type.class.getName()));
        }
        datagram[byteOffset] = (byte)value;
    }
}

