/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.nio.charset.Charset;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.decoder.BinaryDecoder;
import org.indunet.fastproto.decoder.BooleanDecoder;
import org.indunet.fastproto.decoder.ByteDecoder;
import org.indunet.fastproto.decoder.CharacterDecoder;
import org.indunet.fastproto.decoder.DoubleDecoder;
import org.indunet.fastproto.decoder.FloatDecoder;
import org.indunet.fastproto.decoder.Integer16Decoder;
import org.indunet.fastproto.decoder.Integer8Decoder;
import org.indunet.fastproto.decoder.IntegerDecoder;
import org.indunet.fastproto.decoder.LongDecoder;
import org.indunet.fastproto.decoder.ShortDecoder;
import org.indunet.fastproto.decoder.StringDecoder;
import org.indunet.fastproto.decoder.UInteger16Decoder;
import org.indunet.fastproto.decoder.UInteger32Decoder;
import org.indunet.fastproto.decoder.UInteger8Decoder;

public class DecodeUtils {
    protected static BinaryDecoder binaryDecoder = new BinaryDecoder();
    protected static CharacterDecoder characterDecoder = new CharacterDecoder();
    protected static BooleanDecoder booleanDecoder = new BooleanDecoder();
    protected static ByteDecoder byteDecoder = new ByteDecoder();
    protected static ShortDecoder shortDecoder = new ShortDecoder();
    protected static IntegerDecoder integerDecoder = new IntegerDecoder();
    protected static LongDecoder longDecoder = new LongDecoder();
    protected static FloatDecoder floatDecoder = new FloatDecoder();
    protected static DoubleDecoder doubleDecoder = new DoubleDecoder();
    protected static StringDecoder stringDecoder = new StringDecoder();
    protected static Integer8Decoder integer8Decoder = new Integer8Decoder();
    protected static Integer16Decoder integer16Decoder = new Integer16Decoder();
    protected static UInteger8Decoder uInteger8Decoder = new UInteger8Decoder();
    protected static UInteger16Decoder uInteger16Decoder = new UInteger16Decoder();
    protected static UInteger32Decoder uInteger32Decoder = new UInteger32Decoder();

    public static byte[] binaryType(byte[] datagram, int byteOffset, int length) {
        return binaryDecoder.decode(datagram, byteOffset, length);
    }

    public static char characterType(byte[] datagram, int byteOffset) {
        return characterDecoder.decode(datagram, byteOffset, EndianPolicy.LITTLE).charValue();
    }

    public static char characterType(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return characterDecoder.decode(datagram, byteOffset, policy).charValue();
    }

    public static boolean booleanType(byte[] datagram, int byteOffset, int bitOffset) {
        return booleanDecoder.decode(datagram, byteOffset, bitOffset);
    }

    public static int integer8Type(byte[] datagram, int byteOffset) {
        return integer8Decoder.decode(datagram, byteOffset);
    }

    public static int uInteger8Type(byte[] datagram, int byteOffset) {
        return uInteger8Decoder.decode(datagram, byteOffset);
    }

    public static byte byteType(byte[] datagram, int byteOffset) {
        return byteDecoder.decode(datagram, byteOffset);
    }

    public static int integer16Type(byte[] datagram, int byteOffset) {
        return DecodeUtils.integer16Type(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static int integer16Type(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return integer16Decoder.decode(datagram, byteOffset, policy);
    }

    public static int uInteger16Type(byte[] datagram, int byteOffset) {
        return DecodeUtils.uInteger16Type(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static int uInteger16Type(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return uInteger16Decoder.decode(datagram, byteOffset, policy);
    }

    public static short shortType(byte[] datagram, int byteOffset) {
        return DecodeUtils.shortType(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static short shortType(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return shortDecoder.decode(datagram, byteOffset, policy);
    }

    public static long uInteger32Type(byte[] datagram, int byteOffset) {
        return DecodeUtils.uInteger32Type(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static long uInteger32Type(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return uInteger32Decoder.decode(datagram, byteOffset, policy);
    }

    public static int integerType(byte[] datagram, int byteOffset) {
        return DecodeUtils.integerType(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static int integerType(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return integerDecoder.decode(datagram, byteOffset, policy);
    }

    public static long longType(byte[] datagram, int byteOffset) {
        return DecodeUtils.longType(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static long longType(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return longDecoder.decode(datagram, byteOffset, policy);
    }

    public static float floatType(byte[] datagram, int byteOffset) {
        return DecodeUtils.floatType(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static float floatType(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return floatDecoder.decode(datagram, byteOffset, policy);
    }

    public static double doubleType(byte[] datagram, int byteOffset) {
        return DecodeUtils.doubleType(datagram, byteOffset, EndianPolicy.LITTLE);
    }

    public static double doubleType(byte[] datagram, int byteOffset, EndianPolicy policy) {
        return doubleDecoder.decode(datagram, byteOffset, policy);
    }

    public static String stringType(byte[] datagram, int byteOffset, int length) {
        return stringDecoder.decode(datagram, byteOffset, length, Charset.defaultCharset());
    }

    public static String stringType(byte[] datagram, int byteOffset, int length, Charset set) {
        return stringDecoder.decode(datagram, byteOffset, length, set);
    }
}

