package org.indunet.fastproto.annotation.type;

import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.decoder.BinaryDecoder;
import org.indunet.fastproto.encoder.BinaryEncoder;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;

/**
 * Binary type, corresponding to Java byte array.
 *
 * @author Deng Ran
 * @see Type
 * @since 1.0.0
 */
@Type
@Decoder(BinaryDecoder.class)
@Encoder(BinaryEncoder.class)
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BinaryType {
    int value();

    int length() default -1;

    Class<? extends Function<byte[], ?>>[] afterDecode() default {};

    Class<? extends Function<?, byte[]>>[] beforeEncode() default {};
}
