/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.annotation.Compress;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.compress.CompressorFactory;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.Decoders;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.Encoders;

public class FastProto {
    protected static ConcurrentHashMap<Class<?>, TypeAssist> assists = new ConcurrentHashMap();

    public static <T> T decode(@NonNull byte[] datagram, @NonNull Class<T> clazz) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return FastProto.decode(datagram, clazz, true);
    }

    public static <T> T decode(@NonNull byte[] datagram, @NonNull Class<T> clazz, boolean enableCompress) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (enableCompress && clazz.isAnnotationPresent(Compress.class)) {
            Compress compress = clazz.getAnnotation(Compress.class);
            Compressor compressor = CompressorFactory.create(compress);
            datagram = compressor.decompress(datagram);
        }
        TypeAssist assist = assists.computeIfAbsent(clazz, c -> TypeAssist.of(c));
        List<DecodeContext> contexts = assist.toDecodeContexts(datagram);
        Object object = contexts.stream().map(DecodeContext::getObject).map(clazz::cast).findFirst().get();
        contexts.parallelStream().forEach(c -> {
            TypeAssist a = c.getTypeAssist();
            Function<DecodeContext, ?> func = Decoders.getDecoder(a.getDecoderClass(), a.getDecodeFormula());
            Object value = func.apply((DecodeContext)c);
            Object o = c.getObject();
            a.setValue(o, value);
        });
        return (T)object;
    }

    @Deprecated
    public static void encode(@NonNull Object object, @NonNull byte[] datagram) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        TypeAssist assist = assists.computeIfAbsent(object.getClass(), c -> TypeAssist.of(c));
        List<EncodeContext> contexts = assist.toEncodeContexts(object, datagram);
        contexts.stream().forEach(c -> {
            if (c.getTypeAssist().getEncodeFormula() != null) {
                Object o = Encoders.getFormula(c.getTypeAssist().getEncodeFormula()).apply(c.getValue());
                c.setValue(o);
            }
            Consumer<EncodeContext> consumer = Encoders.getEncoder(c.getTypeAssist().getEncoderClass());
            consumer.accept((EncodeContext)c);
        });
    }

    public static byte[] encode(@NonNull Object object, int length) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.encode(object, length, true);
    }

    public static byte[] encode(@NonNull Object object, int length, boolean enableCompress) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        byte[] datagram = new byte[length];
        TypeAssist assist = assists.computeIfAbsent(object.getClass(), c -> TypeAssist.of(c));
        List<EncodeContext> contexts = assist.toEncodeContexts(object, datagram);
        contexts.stream().forEach(c -> {
            if (c.getTypeAssist().getEncodeFormula() != null) {
                Object o = Encoders.getFormula(c.getTypeAssist().getEncodeFormula()).apply(c.getValue());
                c.setValue(o);
            }
            Consumer<EncodeContext> consumer = Encoders.getEncoder(c.getTypeAssist().getEncoderClass());
            consumer.accept((EncodeContext)c);
        });
        if (enableCompress && object.getClass().isAnnotationPresent(Compress.class)) {
            Compress compress = object.getClass().getAnnotation(Compress.class);
            Compressor compressor = CompressorFactory.create(compress);
            return compressor.compress(datagram);
        }
        return datagram;
    }
}

