/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.DecodeIgnore;
import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.EncodeIgnore;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.EncodeException;

public class TypeAssist {
    TypeAssist parent;
    Class<?> type;
    Field field;
    Annotation dataType;
    EndianPolicy endianPolicy;
    Boolean decodeIgnore;
    Boolean encodeIgnore;
    ElementType elementType;
    List<TypeAssist> elements;
    Class<? extends TypeDecoder> decoderClass;
    Class<? extends TypeEncoder> encoderClass;
    Class<? extends Function> decodeFormula;
    Class<? extends Function> encodeFormula;
    Function<DecodeContext, ?> decoder;
    Consumer<?> encoder;

    protected TypeAssist() {
    }

    public static TypeAssist of(Class<?> clazz) {
        Predicate<Field> isType = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(Type.class));
        Stream<TypeAssist> typeStream = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType.negate()).map(f -> {
            f.setAccessible(true);
            Class<?> c = f.getType();
            TypeAssist a = TypeAssist.of(c);
            Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
            Boolean encodeIgnore = f.isAnnotationPresent(EncodeIgnore.class);
            a.setDecodeIgnore(decodeIgnore);
            a.setEncodeIgnore(encodeIgnore);
            a.setField((Field)f);
            return a;
        }).filter(TypeAssist::hasElement);
        EndianPolicy endianPolicy = Optional.ofNullable(clazz.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        Boolean decodeIgnore = clazz.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = clazz.isAnnotationPresent(EncodeIgnore.class);
        Stream<TypeAssist> fieldStream = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType).peek(f -> f.setAccessible(true)).map(TypeAssist::of).peek(a -> {
            if (a.getEndianPolicy() == null) {
                a.setEndianPolicy(endianPolicy);
            }
        });
        TypeAssist assist = TypeAssist.builder().type(clazz).field(null).dataType(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(endianPolicy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.TYPE).build();
        List<TypeAssist> elements = Stream.concat(fieldStream, typeStream).peek(a -> a.setParent(assist)).collect(Collectors.toList());
        assist.setElements(elements);
        return assist;
    }

    protected static TypeAssist of(Field field) {
        EndianPolicy policy = Optional.ofNullable(field.getAnnotation(Endian.class)).map(Endian::value).orElse(null);
        Boolean decodeIgnore = field.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = field.isAnnotationPresent(EncodeIgnore.class);
        Annotation dataType = Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(Type.class)).findAny().orElseThrow(CodecException::new);
        Class decoder = Optional.of(dataType).map(Annotation::annotationType).map(t -> t.getAnnotation(Decoder.class)).map(Decoder::value).orElse(null);
        Class encoder = Optional.of(dataType).map(Annotation::annotationType).map(t -> t.getAnnotation(Encoder.class)).map(Encoder::value).orElse(null);
        Function<String, Class> formula = name -> {
            try {
                Class<? extends Annotation> clazz = dataType.annotationType();
                Method method = clazz.getMethod((String)name, new Class[0]);
                Object array = method.invoke((Object)dataType, new Object[0]);
                return Optional.of(array).filter(a -> a.getClass().isArray()).filter(a -> Array.getLength(a) >= 1).map(a -> Array.get(a, 0)).map(o -> (Class)o).orElse(null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_GETTING_DECODE_FORMULA.getMessage(), dataType.annotationType().getName()));
            }
        };
        Class afterDecode = formula.apply("afterDecode");
        Class beforeEncode = formula.apply("beforeEncode");
        return TypeAssist.builder().type(field.getType()).field(field).dataType(dataType).decoderClass(decoder).encoderClass(encoder).decodeFormula(afterDecode).encodeFormula(beforeEncode).endianPolicy(policy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.FIELD).build();
    }

    public boolean hasElement() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_ASSIGN_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    protected DecodeContext toDecodeContext(byte[] datagram, Object object) {
        return DecodeContext.builder().object(object).datagram(datagram).typeAssist(this).build();
    }

    protected List<DecodeContext> toDecodeContexts(byte[] datagram, Object object) {
        try {
            Object value = this.type.newInstance();
            if (object != null && this.field != null) {
                try {
                    this.field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            Stream<DecodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toDecodeContext(datagram, value));
            Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> a.toDecodeContexts(datagram, value).stream());
            return Stream.concat(fieldStream, classStream).collect(Collectors.toList());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_INITIALIZING_DECODE_OBJECT.getMessage(), this.type.getName()), (Throwable)e);
        }
    }

    public List<DecodeContext> toDecodeContexts(byte[] datagram) {
        return this.toDecodeContexts(datagram, null);
    }

    public EncodeContext toEncodeContext(Object object, byte[] datagram) {
        try {
            return EncodeContext.builder().datagram(datagram).typeAssist(this).value(this.field.get(object)).build();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    public List<EncodeContext> toEncodeContexts(Object object, byte[] datagram) {
        Stream<EncodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toEncodeContext(object, datagram));
        Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> {
            try {
                if (object != null && a.field.get(object) != null) {
                    return a.toEncodeContexts(a.field.get(object), datagram).stream();
                }
                return Stream.empty();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new DecodeException(MessageFormat.format(EncodeException.EncodeError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.type.getName()), (Throwable)e);
            }
        });
        return Stream.concat(fieldStream, classStream).filter(c -> c.getValue() != null).collect(Collectors.toList());
    }

    public static TypeAssistBuilder builder() {
        return new TypeAssistBuilder();
    }

    public TypeAssist getParent() {
        return this.parent;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getDataType() {
        return this.dataType;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodeIgnore() {
        return this.decodeIgnore;
    }

    public Boolean getEncodeIgnore() {
        return this.encodeIgnore;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public List<TypeAssist> getElements() {
        return this.elements;
    }

    public Class<? extends TypeDecoder> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends TypeEncoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Function> getDecodeFormula() {
        return this.decodeFormula;
    }

    public Class<? extends Function> getEncodeFormula() {
        return this.encodeFormula;
    }

    public Function<DecodeContext, ?> getDecoder() {
        return this.decoder;
    }

    public Consumer<?> getEncoder() {
        return this.encoder;
    }

    public void setParent(TypeAssist parent) {
        this.parent = parent;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setDataType(Annotation dataType) {
        this.dataType = dataType;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodeIgnore(Boolean decodeIgnore) {
        this.decodeIgnore = decodeIgnore;
    }

    public void setEncodeIgnore(Boolean encodeIgnore) {
        this.encodeIgnore = encodeIgnore;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public void setElements(List<TypeAssist> elements) {
        this.elements = elements;
    }

    public void setDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        this.decoderClass = decoderClass;
    }

    public void setEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        this.encoderClass = encoderClass;
    }

    public void setDecodeFormula(Class<? extends Function> decodeFormula) {
        this.decodeFormula = decodeFormula;
    }

    public void setEncodeFormula(Class<? extends Function> encodeFormula) {
        this.encodeFormula = encodeFormula;
    }

    public void setDecoder(Function<DecodeContext, ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Consumer<?> encoder) {
        this.encoder = encoder;
    }

    public TypeAssist(TypeAssist parent, Class<?> type, Field field, Annotation dataType, EndianPolicy endianPolicy, Boolean decodeIgnore, Boolean encodeIgnore, ElementType elementType, List<TypeAssist> elements, Class<? extends TypeDecoder> decoderClass, Class<? extends TypeEncoder> encoderClass, Class<? extends Function> decodeFormula, Class<? extends Function> encodeFormula, Function<DecodeContext, ?> decoder, Consumer<?> encoder) {
        this.parent = parent;
        this.type = type;
        this.field = field;
        this.dataType = dataType;
        this.endianPolicy = endianPolicy;
        this.decodeIgnore = decodeIgnore;
        this.encodeIgnore = encodeIgnore;
        this.elementType = elementType;
        this.elements = elements;
        this.decoderClass = decoderClass;
        this.encoderClass = encoderClass;
        this.decodeFormula = decodeFormula;
        this.encodeFormula = encodeFormula;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public static class TypeAssistBuilder {
        private TypeAssist parent;
        private Class<?> type;
        private Field field;
        private Annotation dataType;
        private EndianPolicy endianPolicy;
        private Boolean decodeIgnore;
        private Boolean encodeIgnore;
        private ElementType elementType;
        private List<TypeAssist> elements;
        private Class<? extends TypeDecoder> decoderClass;
        private Class<? extends TypeEncoder> encoderClass;
        private Class<? extends Function> decodeFormula;
        private Class<? extends Function> encodeFormula;
        private Function<DecodeContext, ?> decoder;
        private Consumer<?> encoder;

        TypeAssistBuilder() {
        }

        public TypeAssistBuilder parent(TypeAssist parent) {
            this.parent = parent;
            return this;
        }

        public TypeAssistBuilder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public TypeAssistBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public TypeAssistBuilder dataType(Annotation dataType) {
            this.dataType = dataType;
            return this;
        }

        public TypeAssistBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public TypeAssistBuilder decodeIgnore(Boolean decodeIgnore) {
            this.decodeIgnore = decodeIgnore;
            return this;
        }

        public TypeAssistBuilder encodeIgnore(Boolean encodeIgnore) {
            this.encodeIgnore = encodeIgnore;
            return this;
        }

        public TypeAssistBuilder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public TypeAssistBuilder elements(List<TypeAssist> elements) {
            this.elements = elements;
            return this;
        }

        public TypeAssistBuilder decoderClass(Class<? extends TypeDecoder> decoderClass) {
            this.decoderClass = decoderClass;
            return this;
        }

        public TypeAssistBuilder encoderClass(Class<? extends TypeEncoder> encoderClass) {
            this.encoderClass = encoderClass;
            return this;
        }

        public TypeAssistBuilder decodeFormula(Class<? extends Function> decodeFormula) {
            this.decodeFormula = decodeFormula;
            return this;
        }

        public TypeAssistBuilder encodeFormula(Class<? extends Function> encodeFormula) {
            this.encodeFormula = encodeFormula;
            return this;
        }

        public TypeAssistBuilder decoder(Function<DecodeContext, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TypeAssistBuilder encoder(Consumer<?> encoder) {
            this.encoder = encoder;
            return this;
        }

        public TypeAssist build() {
            return new TypeAssist(this.parent, this.type, this.field, this.dataType, this.endianPolicy, this.decodeIgnore, this.encodeIgnore, this.elementType, this.elements, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder);
        }

        public String toString() {
            return "TypeAssist.TypeAssistBuilder(parent=" + this.parent + ", type=" + this.type + ", field=" + this.field + ", dataType=" + this.dataType + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodeIgnore=" + this.decodeIgnore + ", encodeIgnore=" + this.encodeIgnore + ", elementType=" + (Object)((Object)this.elementType) + ", elements=" + this.elements + ", decoderClass=" + this.decoderClass + ", encoderClass=" + this.encoderClass + ", decodeFormula=" + this.decodeFormula + ", encodeFormula=" + this.encodeFormula + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ")";
        }
    }
}

