/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class BinaryDecoder
implements TypeDecoder<byte[]> {
    @Override
    public byte[] decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        BinaryType type = context.getDataType(BinaryType.class);
        return this.decode(context.getDatagram(), type.value(), type.length());
    }

    public byte[] decode(@NonNull byte[] datagram, int byteOffset, int length) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (length < -1) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_PARAMETER);
        }
        if (length == -1 && byteOffset >= datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (length != -1 && byteOffset + length > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (length == -1) {
            length = datagram.length - byteOffset;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(datagram, byteOffset, bytes, 0, length);
        return bytes;
    }
}

