/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class ByteDecoder
implements TypeDecoder<Byte> {
    @Override
    public Byte decode(DecodeContext context) {
        ByteType type = context.getDataType(ByteType.class);
        return this.decode(context.getDatagram(), type.value());
    }

    public byte decode(@NonNull byte[] datagram, int byteOffset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 1 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        return datagram[byteOffset];
    }
}

