/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Type;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.util.DecodeUtils;

public class TimestampDecoder
implements TypeDecoder<Timestamp> {
    @Override
    public Timestamp decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EndianPolicy policy = context.getEndianPolicy();
        TimestampType type = context.getDataType(TimestampType.class);
        Type.DataType dataType = type.dataType();
        return this.decode(context.getDatagram(), type.value(), dataType, policy, type.unit());
    }

    public Timestamp decode(@NonNull byte[] datagram, int byteOffset, @NonNull Type.DataType dataType, @NonNull EndianPolicy policy, @NonNull TimeUnit unit) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (dataType == Type.DataType.LONG_TYPE && unit == TimeUnit.MILLISECONDS) {
            if (byteOffset + 8 > datagram.length) {
                throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            long value = DecodeUtils.longType(datagram, byteOffset);
            return new Timestamp(value);
        }
        if (dataType == Type.DataType.INTEGER_TYPE && unit == TimeUnit.SECONDS) {
            if (byteOffset + 4 > datagram.length) {
                throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
            }
            int value = DecodeUtils.integerType(datagram, byteOffset);
            return new Timestamp(value * 1000);
        }
        throw new DecodeException(DecodeException.DecodeError.ILLEGAL_TIMESTAMP_PARAMETERS);
    }
}

