/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class LongEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        LongType type = context.getDataType(LongType.class);
        Long value = context.getValue(Long.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy, long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (byteOffset + 8 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.BIG) {
            datagram[byteOffset + 7] = (byte)(value & 0xFFL);
            datagram[byteOffset + 6] = (byte)(value >> 8 & 0xFFL);
            datagram[byteOffset + 5] = (byte)(value >> 16 & 0xFFL);
            datagram[byteOffset + 4] = (byte)(value >> 24 & 0xFFL);
            datagram[byteOffset + 3] = (byte)(value >> 32 & 0xFFL);
            datagram[byteOffset + 2] = (byte)(value >> 40 & 0xFFL);
            datagram[byteOffset + 1] = (byte)(value >> 48 & 0xFFL);
            datagram[byteOffset] = (byte)(value >> 56 & 0xFFL);
        } else {
            datagram[byteOffset] = (byte)(value & 0xFFL);
            datagram[byteOffset + 1] = (byte)(value >> 8 & 0xFFL);
            datagram[byteOffset + 2] = (byte)(value >> 16 & 0xFFL);
            datagram[byteOffset + 3] = (byte)(value >> 24 & 0xFFL);
            datagram[byteOffset + 4] = (byte)(value >> 32 & 0xFFL);
            datagram[byteOffset + 5] = (byte)(value >> 40 & 0xFFL);
            datagram[byteOffset + 6] = (byte)(value >> 48 & 0xFFL);
            datagram[byteOffset + 7] = (byte)(value >> 56 & 0xFFL);
        }
    }
}

