/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger32Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class UInteger32Encoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        UInteger32Type type = context.getDataType(UInteger32Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        Long value = context.getValue(Long.class);
        this.encode(context.getDatagram(), type.value(), policy, value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy, long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 4 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (value > 0xFFFFFFFFL || value < 0L) {
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.EXCEEDED_TYPE_SIZE_LIMIT.getMessage(), UInteger32Type.class.getName()));
        }
        if (policy == EndianPolicy.BIG) {
            datagram[byteOffset + 3] = (byte)(value & 0xFFL);
            datagram[byteOffset + 2] = (byte)(value >> 8 & 0xFFL);
            datagram[byteOffset + 1] = (byte)(value >> 16 & 0xFFL);
            datagram[byteOffset] = (byte)(value >> 24 & 0xFFL);
        } else {
            datagram[byteOffset] = (byte)(value & 0xFFL);
            datagram[byteOffset + 1] = (byte)(value >> 8 & 0xFFL);
            datagram[byteOffset + 2] = (byte)(value >> 16 & 0xFFL);
            datagram[byteOffset + 3] = (byte)(value >> 24 & 0xFFL);
        }
    }
}

