/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Arrays;
import org.indunet.fastproto.exception.CodecException;

public enum EndianPolicy {
    BIG(1, "Big"),
    LITTLE(2, "Little");

    int code;
    String name;

    public static EndianPolicy byName(String name) {
        return Arrays.stream(EndianPolicy.values()).filter(p -> p.getName().equals(name)).findFirst().orElseThrow(() -> new CodecException(CodecException.CodecError.INVALID_ENDIAN_POLICY));
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private EndianPolicy(int code, String name) {
        this.code = code;
        this.name = name;
    }
}

