/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.Integer16Type;
import org.indunet.fastproto.annotation.type.Integer8Type;
import org.indunet.fastproto.annotation.type.IntegerType;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.annotation.type.UInteger16Type;
import org.indunet.fastproto.annotation.type.UInteger32Type;
import org.indunet.fastproto.annotation.type.UInteger8Type;
import org.indunet.fastproto.exception.CodecException;

public enum ProtocolType {
    BINARY(BinaryType.class, true),
    BOOLEAN(BooleanType.class, true),
    BYTE(ByteType.class, true),
    DOUBLE(DoubleType.class, true),
    FLOAT(FloatType.class, true),
    INTEGER(IntegerType.class, true),
    LONG(LongType.class, true),
    SHORT(ShortType.class, true),
    STRING(StringType.class, true),
    TIMESTAMP(TimestampType.class, true),
    INTEGER8(Integer8Type.class, false),
    INTEGER16(Integer16Type.class, false),
    UINTEGER8(UInteger8Type.class, false),
    UINTEGER16(UInteger16Type.class, false),
    UINTEGER32(UInteger32Type.class, false);

    Class<? extends Annotation> typeAnnotationClass;
    Boolean autoType;

    public static ProtocolType valueOf(Class<? extends Annotation> clazz) {
        return Arrays.stream(ProtocolType.values()).filter(t -> t.typeAnnotationClass == clazz).findFirst().orElseThrow(CodecException::new);
    }

    public static ProtocolType byAutoType(Type type) {
        return Arrays.stream(ProtocolType.values()).filter(t -> Arrays.asList(t.javaTypes()).contains(type)).findFirst().orElseThrow(CodecException::new);
    }

    public Type javaType() {
        return this.javaTypes()[0];
    }

    public Type[] javaTypes() {
        Field field = this.typeAnnotationClass.getField("JAVA_TYPES");
        return (Type[])field.get(null);
    }

    private ProtocolType(Class<? extends Annotation> typeAnnotationClass, Boolean autoType) {
        this.typeAnnotationClass = typeAnnotationClass;
        this.autoType = autoType;
    }

    public Class<? extends Annotation> getTypeAnnotationClass() {
        return this.typeAnnotationClass;
    }

    public Boolean getAutoType() {
        return this.autoType;
    }
}

