/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import lombok.NonNull;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.exception.DecodeException;

public class DeflateCompressor
implements Compressor {
    Deflater deflater;
    Inflater inflater;

    public DeflateCompressor() {
        this(1);
    }

    public DeflateCompressor(int level) {
        this.deflater = new Deflater(level);
        this.inflater = new Inflater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] compress(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.deflater.setInput(bytes);
            this.deflater.finish();
            byte[] buffer = new byte[256];
            while (!this.deflater.finished()) {
                int n = this.deflater.deflate(buffer);
                out.write(buffer, 0, n);
            }
        }
        finally {
            this.deflater.end();
        }
        return out.toByteArray();
    }

    @Override
    public synchronized byte[] decompress(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.inflater.setInput(bytes);
            this.inflater.finished();
            byte[] buffer = new byte[256];
            while (!this.inflater.finished()) {
                int n = this.inflater.inflate(buffer);
                out.write(buffer, 0, n);
            }
        }
        catch (DataFormatException e) {
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_DECOMPRESS_DATAGRAM.getMessage(), this.getClass().getName()), (Throwable)e);
        }
        finally {
            this.inflater.end();
        }
        return out.toByteArray();
    }
}

