/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.IntegerType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class IntegerDecoder
implements TypeDecoder<Integer> {
    @Override
    public Integer decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        IntegerType type = context.getDataType(IntegerType.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public int decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 4 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        int value = 0;
        if (endian == EndianPolicy.LITTLE) {
            value |= datagram[byteOffset] & 0xFF;
            value |= (datagram[byteOffset + 1] & 0xFF) << 8;
            value |= (datagram[byteOffset + 2] & 0xFF) << 16;
            value |= (datagram[byteOffset + 3] & 0xFF) << 24;
        } else if (endian == EndianPolicy.BIG) {
            value |= datagram[byteOffset + 3] & 0xFF;
            value |= (datagram[byteOffset + 2] & 0xFF) << 8;
            value |= (datagram[byteOffset + 1] & 0xFF) << 16;
            value |= (datagram[byteOffset] & 0xFF) << 24;
        }
        return value;
    }
}

