/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.NonNull;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class StringDecoder
implements TypeDecoder<String> {
    @Override
    public String decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        StringType type = context.getDataType(StringType.class);
        return this.decode(context.getDatagram(), type.value(), type.length(), Charset.forName(type.charsetName()));
    }

    public String decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull Charset charset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (length < -1) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_PARAMETER);
        }
        if (length == -1 && byteOffset >= datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (length != -1 && byteOffset + length > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (length == -1) {
            return new String(Arrays.copyOfRange(datagram, byteOffset, datagram.length - byteOffset), charset);
        }
        return new String(Arrays.copyOfRange(datagram, byteOffset, byteOffset + length), charset);
    }
}

